/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.interceptors.dynamic.AbstractCollectionInterceptor;
import org.jboss.cache.pojo.util.CacheApiUtil;
import org.jboss.cache.pojo.util.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedMapImpl
implements Map {
    private PojoCacheImpl pojoCache;
    private Cache<Object, Object> cache;
    private AbstractCollectionInterceptor interceptor;

    public CachedMapImpl(PojoCacheImpl pCache, AbstractCollectionInterceptor interceptor) {
        this.pojoCache = pCache;
        this.cache = this.pojoCache.getCache();
        this.interceptor = interceptor;
    }

    private static Fqn constructFqn(Fqn baseFqn, Object relative) {
        if (!(relative instanceof Serializable) && !(relative instanceof Advised)) {
            throw new PojoCacheException("Non-serializable for " + relative.getClass().getName());
        }
        return new Fqn(baseFqn, new Object[]{relative});
    }

    private Fqn getFqn() {
        return this.interceptor.getFqn();
    }

    private Object attach(Object key, Object value) {
        Fqn fqn = CachedMapImpl.constructFqn(this.getFqn(), Null.toNullKeyObject(key));
        Object o = this.pojoCache.attach(fqn, Null.toNullObject(value));
        this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"PUT");
        return o;
    }

    private Object detach(Object key) {
        Fqn fqn = CachedMapImpl.constructFqn(this.getFqn(), Null.toNullKeyObject(key));
        this.pojoCache.getCache().put(fqn, (Object)"POJOCache.Operation", (Object)"REMOVE");
        return this.pojoCache.detach(fqn);
    }

    private Set<Node> getNodeChildren() {
        return CacheApiUtil.getNodeChildren(this.cache, this.getFqn());
    }

    public Object get(Object key) {
        return Null.toNullValue(this.pojoCache.find(CachedMapImpl.constructFqn(this.getFqn(), Null.toNullKeyObject(key))));
    }

    public Object put(Object key, Object value) {
        return this.attach(key, value);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        return this.detach(key);
    }

    @Override
    public void clear() {
        ArrayList list = new ArrayList(this.keySet());
        for (int i = 0; i < list.size(); ++i) {
            this.remove(list.get(i));
        }
    }

    @Override
    public int size() {
        Set<Node> children = this.getNodeChildren();
        return children == null ? 0 : children.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        Set<Node> children = this.getNodeChildren();
        if (children == null) {
            return false;
        }
        for (Node n : children) {
            if (!n.getFqn().getLastElement().equals(Null.toNullKeyObject(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values().contains(Null.toNullObject(object));
    }

    public Set entrySet() {
        final CachedMapImpl map = this;
        return new AbstractSet(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                final Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = ((Node)i.next()).getFqn().getLastElement();
                        return new Entry(this.lastKey);
                    }

                    public void remove() {
                        map.remove(this.lastKey);
                    }
                };
            }
        };
    }

    public Collection values() {
        final CachedMapImpl map = this;
        return new AbstractCollection(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public void clear() {
                map.clear();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                final Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        Fqn f = ((Node)i.next()).getFqn();
                        this.lastKey = f.getLastElement();
                        return Null.toNullValue(CachedMapImpl.this.pojoCache.find(f));
                    }

                    public void remove() {
                        Object key = this.lastKey;
                        if (key != null) {
                            key = Null.toNullKeyValue(key);
                        }
                        map.remove(key);
                    }
                };
            }
        };
    }

    public Set keySet() {
        final CachedMapImpl map = this;
        return new AbstractSet(){

            public int size() {
                Set children = CachedMapImpl.this.getNodeChildren();
                return children == null ? 0 : children.size();
            }

            public Iterator iterator() {
                Set children = CachedMapImpl.this.getNodeChildren();
                final Iterator i = children == null ? Collections.EMPTY_LIST.iterator() : children.iterator();
                return new Iterator(){
                    Object lastKey;

                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    public Object next() {
                        this.lastKey = ((Node)i.next()).getFqn().getLastElement();
                        return Null.toNullKeyValue(this.lastKey);
                    }

                    public void remove() {
                        Object key = this.lastKey;
                        if (key != null) {
                            key = Null.toNullKeyValue(key);
                        }
                        map.remove(key);
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int result = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            result += i.next().hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        for (Entry entry : this.entrySet()) {
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (!(value == null ? map.get(key) != null || !map.containsKey(key) : !value.equals(map.get(key)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set set = this.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = this.get(key);
            if (key == this.interceptor.getBoundProxy()) {
                key = "(this map)";
            }
            if (value == this.interceptor.getBoundProxy()) {
                value = "(this map)";
            }
            buf.append("[").append(key).append(", ").append(value).append("]");
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    class Entry
    implements Map.Entry {
        Object key;

        public Entry(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return Null.toNullValue(this.key);
        }

        public Object getValue() {
            return Null.toNullValue(CachedMapImpl.this.pojoCache.find(CachedMapImpl.constructFqn(CachedMapImpl.this.getFqn(), this.key)));
        }

        public Object setValue(Object value) {
            return CachedMapImpl.this.attach(this.key, value);
        }

        public int hashCode() {
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            Object value = this.getValue();
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
        }
    }
}

