/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.SuspectException;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.jmx.annotations.MBean;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockUtil;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.CommandAwareRpcDispatcher;
import org.jboss.cache.marshall.InactiveRegionAwareRpcDispatcher;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.remoting.jgroups.ChannelMessageListener;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.concurrent.ReclosableLatch;
import org.jboss.cache.util.reflect.ReflectionUtil;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.StateTransferException;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(objectName="RPCManager")
public class RPCManagerImpl
implements RPCManager {
    private Channel channel;
    private final Log log = LogFactory.getLog(RPCManagerImpl.class);
    private List<Address> members;
    private long replicationCount;
    private long replicationFailures;
    private boolean statisticsEnabled = false;
    private final Object coordinatorLock = new Object();
    private volatile boolean coordinator = false;
    private final ReclosableLatch flushBlockGate = new ReclosableLatch();
    private CommandAwareRpcDispatcher rpcDispatcher = null;
    private ChannelMessageListener messageListener;
    private Configuration configuration;
    private Notifier notifier;
    private CacheSPI spi;
    private InvocationContextContainer invocationContextContainer;
    private final boolean trace = this.log.isTraceEnabled();
    private Marshaller marshaller;
    private TransactionManager txManager;
    private TransactionTable txTable;
    private InterceptorChain interceptorChain;
    private boolean isUsingBuddyReplication;
    private boolean isInLocalMode;
    private ComponentRegistry componentRegistry;
    private LockManager lockManager;

    @Inject
    public void setupDependencies(ChannelMessageListener messageListener, Configuration configuration, Notifier notifier, CacheSPI spi, Marshaller marshaller, TransactionTable txTable, TransactionManager txManager, InvocationContextContainer container, InterceptorChain interceptorChain, ComponentRegistry componentRegistry, LockManager lockManager) {
        this.messageListener = messageListener;
        this.configuration = configuration;
        this.notifier = notifier;
        this.spi = spi;
        this.marshaller = marshaller;
        this.txManager = txManager;
        this.txTable = txTable;
        this.invocationContextContainer = container;
        this.interceptorChain = interceptorChain;
        this.componentRegistry = componentRegistry;
        this.lockManager = lockManager;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Start(priority=15)
    public void start() {
        switch (1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[this.configuration.getCacheMode().ordinal()]) {
            case 1: {
                this.log.debug((Object)"cache mode is local, will not create the channel");
                this.isInLocalMode = true;
                this.isUsingBuddyReplication = false;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.isInLocalMode = false;
                v0 = this.isUsingBuddyReplication = this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled() != false;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cache mode is " + (Object)this.configuration.getCacheMode()));
                }
                fetchState = this.shouldFetchStateOnStartup();
                this.initialiseChannelAndRpcDispatcher(fetchState);
                if (fetchState) {
                    try {
                        start = System.currentTimeMillis();
                        this.channel.connect(this.configuration.getClusterName(), null, null, this.configuration.getStateRetrievalTimeout());
                        if (this.getMembers().size() > 1) {
                            this.messageListener.waitForState();
                        }
                        if (!this.log.isDebugEnabled()) ** GOTO lbl35
                        this.log.debug((Object)("connected, state was retrieved successfully (in " + (System.currentTimeMillis() - start) + " milliseconds)"));
                    }
                    catch (StateTransferException ste) {
                        this.disconnect();
                        throw new CacheException("Unable to fetch state on startup", ste);
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                    catch (Exception ex) {
                        throw new CacheException("Unable to fetch state on startup", ex);
                    }
                } else {
                    try {
                        this.channel.connect(this.configuration.getClusterName());
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                }
lbl35:
                // 3 sources

                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)("Cache local address is " + this.getLocalAddress()));
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.channel != null && this.channel.isOpen()) {
            this.log.info((Object)"Disconnecting and closing the Channel");
            this.channel.disconnect();
            this.channel.close();
        }
    }

    @Override
    @Stop(priority=8)
    public void stop() {
        try {
            this.disconnect();
        }
        catch (Exception toLog) {
            this.log.error((Object)"Problem closing channel; setting it to null", (Throwable)toLog);
        }
        this.channel = null;
        this.configuration.getRuntimeConfig().setChannel(null);
        if (this.rpcDispatcher != null) {
            this.log.info((Object)"Stopping the RpcDispatcher");
            this.rpcDispatcher.stop();
        }
        if (this.members != null) {
            this.members = null;
        }
        this.coordinator = false;
        this.rpcDispatcher = null;
    }

    private boolean shouldFetchStateOnStartup() {
        boolean loaderFetch = this.configuration.getCacheLoaderConfig() != null && this.configuration.getCacheLoaderConfig().isFetchPersistentState();
        return !this.configuration.isInactiveOnStartup() && !this.isUsingBuddyReplication && (this.configuration.isFetchInMemoryState() || loaderFetch);
    }

    private void initialiseChannelAndRpcDispatcher(boolean fetchState) throws CacheException {
        this.channel = this.configuration.getRuntimeConfig().getChannel();
        if (this.channel == null) {
            this.channel = this.getMultiplexerChannel();
            if (this.channel != null) {
                ReflectionUtil.setValue(this.configuration, "accessible", true);
                this.configuration.setUsingMultiplexer(true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Created Multiplexer Channel for cache cluster " + this.configuration.getClusterName() + " using stack " + this.configuration.getMultiplexerStack()));
                }
            } else {
                try {
                    if (this.configuration.getJGroupsConfigFile() != null) {
                        URL u = this.configuration.getJGroupsConfigFile();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Grabbing cluster properties from " + u));
                        }
                        this.channel = new JChannel(u);
                    } else if (this.configuration.getClusterConfig() == null) {
                        this.log.debug((Object)"setting cluster properties to default value");
                        this.channel = new JChannel(this.configuration.getDefaultClusterConfig());
                    } else {
                        if (this.trace) {
                            this.log.trace((Object)("Cache cluster properties: " + this.configuration.getClusterConfig()));
                        }
                        this.channel = new JChannel(this.configuration.getClusterConfig());
                    }
                }
                catch (ChannelException e) {
                    throw new CacheException(e);
                }
            }
            this.configuration.getRuntimeConfig().setChannel(this.channel);
        }
        this.channel.setOpt(3, (Object)false);
        this.channel.setOpt(5, (Object)true);
        this.channel.setOpt(6, (Object)fetchState);
        this.channel.setOpt(0, (Object)true);
        this.rpcDispatcher = this.configuration.isUseRegionBasedMarshalling() ? new InactiveRegionAwareRpcDispatcher(this.channel, (MessageListener)this.messageListener, (MembershipListener)new MembershipListenerAdaptor(), this.spi, this.invocationContextContainer, this.interceptorChain, this.componentRegistry) : new CommandAwareRpcDispatcher(this.channel, (MessageListener)this.messageListener, (MembershipListener)new MembershipListenerAdaptor(), this.invocationContextContainer, this.invocationContextContainer, this.interceptorChain, this.componentRegistry);
        this.checkAppropriateConfig();
        this.rpcDispatcher.setRequestMarshaller((RpcDispatcher.Marshaller)this.marshaller);
        this.rpcDispatcher.setResponseMarshaller((RpcDispatcher.Marshaller)this.marshaller);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    private JChannel getMultiplexerChannel() throws CacheException {
        String stackName = this.configuration.getMultiplexerStack();
        RuntimeConfig rtc = this.configuration.getRuntimeConfig();
        ChannelFactory channelFactory = rtc.getMuxChannelFactory();
        JChannel muxchannel = null;
        if (channelFactory != null) {
            try {
                muxchannel = (JChannel)channelFactory.createMultiplexerChannel(stackName, this.configuration.getClusterName());
            }
            catch (Exception e) {
                throw new CacheException("Failed to create multiplexed channel using stack " + stackName, e);
            }
        }
        return muxchannel;
    }

    @Deprecated
    private void removeLocksForDeadMembers(NodeSPI node, List deadMembers) {
        HashSet<GlobalTransaction> deadOwners = new HashSet<GlobalTransaction>();
        Object owner = this.lockManager.getWriteOwner(node);
        if (this.isLockOwnerDead(owner, deadMembers)) {
            deadOwners.add((GlobalTransaction)owner);
        }
        for (Object object : this.lockManager.getReadOwners(node)) {
            if (!this.isLockOwnerDead(object, deadMembers)) continue;
            deadOwners.add((GlobalTransaction)object);
        }
        for (GlobalTransaction globalTransaction : deadOwners) {
            boolean localTx = globalTransaction.getAddress().equals(this.getLocalAddress());
            boolean broken = LockUtil.breakTransactionLock(node.getFqn(), this.lockManager, globalTransaction, localTx, this.txTable, this.txManager);
            if (!broken || !this.trace) continue;
            this.log.trace((Object)("Broke lock for node " + node.getFqn() + " held by " + globalTransaction));
        }
        for (Object object : node.getChildrenDirect()) {
            this.removeLocksForDeadMembers((NodeSPI)object, deadMembers);
        }
    }

    private void removeLocksForDeadMembers(InternalNode<?, ?> node, List deadMembers) {
        HashSet<GlobalTransaction> deadOwners = new HashSet<GlobalTransaction>();
        Object owner = this.lockManager.getWriteOwner(node.getFqn());
        if (this.isLockOwnerDead(owner, deadMembers)) {
            deadOwners.add((GlobalTransaction)owner);
        }
        for (GlobalTransaction globalTransaction : deadOwners) {
            boolean localTx = globalTransaction.getAddress().equals(this.getLocalAddress());
            boolean broken = LockUtil.breakTransactionLock(node.getFqn(), this.lockManager, globalTransaction, localTx, this.txTable, this.txManager);
            if (!broken || !this.trace) continue;
            this.log.trace((Object)("Broke lock for node " + node.getFqn() + " held by " + globalTransaction));
        }
        for (InternalNode internalNode : node.getChildren()) {
            this.removeLocksForDeadMembers(internalNode, deadMembers);
        }
    }

    private boolean isLockOwnerDead(Object owner, List deadMembers) {
        boolean result = false;
        if (owner != null && owner instanceof GlobalTransaction) {
            Object addr = ((GlobalTransaction)owner).getAddress();
            result = deadMembers.contains(addr);
        }
        return result;
    }

    @Override
    public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand command, int mode, long timeout, boolean useOutOfBandMessage) throws Exception {
        return this.callRemoteMethods(recipients, command, mode, timeout, null, useOutOfBandMessage);
    }

    @Override
    public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand command, boolean synchronous, long timeout, boolean useOutOfBandMessage) throws Exception {
        return this.callRemoteMethods(recipients, command, synchronous ? 2 : 6, timeout, useOutOfBandMessage);
    }

    @Override
    public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand command, int mode, long timeout, RspFilter responseFilter, boolean useOutOfBandMessage) throws Exception {
        RspList rsps;
        boolean success;
        block17: {
            block16: {
                block15: {
                    success = true;
                    if (this.rpcDispatcher != null) break block15;
                    List<Object> list = null;
                    Object var17_11 = null;
                    this.computeStats(success);
                    return list;
                }
                int modeToUse = mode;
                int preferredMode = this.spi.getInvocationContext().getOptionOverrides().getGroupRequestMode();
                if (preferredMode > -1) {
                    modeToUse = preferredMode;
                }
                if (this.trace) {
                    this.log.trace((Object)("callRemoteMethods(): valid members are " + recipients + " methods: " + command + " Using OOB? " + useOutOfBandMessage));
                }
                if (this.channel.flushSupported() && !this.flushBlockGate.await(this.configuration.getStateRetrievalTimeout(), TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("State retrieval timed out waiting for flush unblock.");
                }
                useOutOfBandMessage = false;
                rsps = this.rpcDispatcher.invokeRemoteCommands(recipients, command, modeToUse, timeout, this.isUsingBuddyReplication, useOutOfBandMessage, responseFilter);
                if (mode != 6) break block16;
                List<Object> list = Collections.emptyList();
                Object var17_12 = null;
                this.computeStats(success);
                return list;
            }
            if (this.trace) {
                this.log.trace((Object)("(" + this.getLocalAddress() + "): responses for method " + command.getClass().getSimpleName() + ":\n" + rsps));
            }
            if (rsps != null) break block17;
            List<Object> list = Collections.emptyList();
            Object var17_13 = null;
            this.computeStats(success);
            return list;
        }
        try {
            ArrayList<Object> retval = new ArrayList<Object>(rsps.size());
            for (Rsp rsp : rsps.values()) {
                if (rsp.wasSuspected() || !rsp.wasReceived()) {
                    CacheException ex = rsp.wasSuspected() ? new SuspectException("Suspected member: " + rsp.getSender()) : new TimeoutException("Replication timeout for " + rsp.getSender());
                    retval.add(new ReplicationException("rsp=" + rsp, ex));
                    success = false;
                    continue;
                }
                Object value = rsp.getValue();
                if (value instanceof Exception && !(value instanceof ReplicationException)) {
                    if (this.trace) {
                        this.log.trace((Object)("Recieved exception'" + value + "' from " + rsp.getSender()));
                    }
                    throw (Exception)value;
                }
                retval.add(value);
                success = true;
            }
            ArrayList<Object> arrayList = retval;
            Object var17_14 = null;
            this.computeStats(success);
            return arrayList;
        }
        catch (Exception e) {
            try {
                success = false;
                throw e;
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                this.computeStats(success);
                throw throwable;
            }
        }
    }

    @Override
    public void fetchPartialState(List<Address> sources, Fqn sourceTarget, Fqn integrationTarget) throws Exception {
        String encodedStateId = sourceTarget + "_PARTIAL_STATE_DELIMITER" + integrationTarget;
        this.fetchPartialState(sources, encodedStateId);
    }

    @Override
    public void fetchPartialState(List<Address> sources, Fqn subtree) throws Exception {
        if (subtree == null) {
            throw new IllegalArgumentException("Cannot fetch partial state. Null subtree.");
        }
        this.fetchPartialState(sources, subtree.toString());
    }

    private void fetchPartialState(List<Address> sources, String stateId) throws Exception {
        if (sources == null || sources.isEmpty() || stateId == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Cannot fetch partial state, targets are " + sources + " and stateId is " + stateId));
            }
            return;
        }
        LinkedList<Address> targets = new LinkedList<Address>(sources);
        targets.remove(this.getLocalAddress());
        if (targets.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Cannot fetch partial state. There are no target members specified");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from members " + targets));
        }
        boolean successfulTransfer = false;
        for (Address target : targets) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target));
                }
                this.messageListener.setStateSet(false);
                successfulTransfer = this.channel.getState(target, stateId, this.configuration.getStateRetrievalTimeout());
                if (successfulTransfer) {
                    try {
                        this.messageListener.waitForState();
                    }
                    catch (Exception transferFailed) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Error while fetching state", (Throwable)transferFailed);
                        }
                        successfulTransfer = false;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target + (successfulTransfer ? " successful" : " failed")));
                }
                if (!successfulTransfer) continue;
                break;
            }
            catch (IllegalStateException ise) {
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)"Channel problems fetching state.  Continuing on to next provider. ", (Throwable)ise);
            }
        }
        if (!successfulTransfer && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " could not fetch partial state " + stateId + " from any member " + targets));
        }
    }

    @ManagedAttribute(description="Local address")
    public String getLocalAddressString() {
        Address address = this.getLocalAddress();
        return address == null ? "null" : address.toString();
    }

    @Override
    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    @ManagedAttribute(description="Cluster view")
    public String getMembersString() {
        List<Address> l = this.getMembers();
        return l == null ? "null" : l.toString();
    }

    @Override
    public List<Address> getMembers() {
        if (this.isInLocalMode) {
            return null;
        }
        if (this.members == null) {
            return Collections.emptyList();
        }
        return this.members;
    }

    @Override
    public boolean isCoordinator() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getCoordinator() {
        if (this.channel == null) {
            return null;
        }
        Object object = this.coordinatorLock;
        synchronized (object) {
            while (this.members == null || this.members.isEmpty()) {
                this.log.debug((Object)"getCoordinator(): waiting on viewAccepted()");
                try {
                    this.coordinatorLock.wait();
                }
                catch (InterruptedException e) {
                    this.log.error((Object)"getCoordinator(): Interrupted while waiting for members to be set", (Throwable)e);
                    break;
                }
            }
            return this.members != null && this.members.size() > 0 ? this.members.get(0) : null;
        }
    }

    private void computeStats(boolean success) {
        if (this.statisticsEnabled && this.rpcDispatcher != null) {
            if (success) {
                ++this.replicationCount;
            } else {
                ++this.replicationFailures;
            }
        }
    }

    @ManagedOperation
    public void resetStatistics() {
        this.replicationCount = 0L;
        this.replicationFailures = 0L;
    }

    @ManagedAttribute(description="number of successful replications")
    public long getReplicationCount() {
        return this.replicationCount;
    }

    @ManagedAttribute(description="number of failed replications")
    public long getReplicationFailures() {
        return this.replicationFailures;
    }

    @ManagedAttribute(description="whether or not jmx statistics are enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="RPC call success ratio")
    public String getSuccessRatio() {
        if (this.replicationCount == 0L || !this.statisticsEnabled) {
            return "N/A";
        }
        double totalCount = this.replicationCount + this.replicationFailures;
        double ration = (double)this.replicationCount / totalCount * 100.0;
        return NumberFormat.getInstance().format(ration) + "%";
    }

    private void checkAppropriateConfig() {
        ProtocolStack stack;
        TP transport;
        if (this.configuration.getMultiplexerStack() != null) {
            return;
        }
        Configuration.CacheMode cacheMode = this.configuration.getCacheMode();
        if (!cacheMode.equals((Object)Configuration.CacheMode.LOCAL) && this.configuration.getCacheMode().isSynchronous() && (transport = (stack = ((JChannel)this.channel).getProtocolStack()).getTransport()).isEnableBundling()) {
            this.log.warn((Object)"You have enabled jgroups's message bundling, which is not recommended for sync replication. If there is no particular reason for this we strongly recommend to disable message bundling in JGroups config (enable_bundling=\"false\").");
        }
        if (!cacheMode.isSynchronous() && !(transport = (stack = ((JChannel)this.channel).getProtocolStack()).getTransport()).isEnableBundling()) {
            this.log.warn((Object)"You have disabled jgroups's message bundling, which is not recommended for async replication. If there is no particular reason for this we strongly recommend to enable message bundling in JGroups config (enable_bundling=\"true\").");
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$jboss$cache$config$Configuration$CacheMode;

        static {
            $SwitchMap$org$jboss$cache$config$Configuration$CacheMode = new int[Configuration.CacheMode.values().length];
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.REPL_SYNC.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.REPL_ASYNC.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.INVALIDATION_ASYNC.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$jboss$cache$config$Configuration$CacheMode[Configuration.CacheMode.INVALIDATION_SYNC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    protected class MembershipListenerAdaptor
    implements ExtendedMembershipListener {
        protected MembershipListenerAdaptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View newView) {
            Vector newMembers = newView.getMembers();
            if (RPCManagerImpl.this.log.isInfoEnabled()) {
                RPCManagerImpl.this.log.info((Object)("Received new cluster view: " + newView));
            }
            Object object = RPCManagerImpl.this.coordinatorLock;
            synchronized (object) {
                boolean needNotification = false;
                if (newMembers != null) {
                    if (RPCManagerImpl.this.members != null) {
                        ArrayList removed = new ArrayList(RPCManagerImpl.this.members);
                        removed.removeAll(newMembers);
                        RPCManagerImpl.this.spi.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
                        NodeSPI root = RPCManagerImpl.this.spi.getRoot();
                        if (root != null) {
                            if (RPCManagerImpl.this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.MVCC) {
                                RPCManagerImpl.this.removeLocksForDeadMembers(root.getDelegationTarget(), removed);
                            } else {
                                RPCManagerImpl.this.removeLocksForDeadMembers(root, removed);
                            }
                        }
                    }
                    RPCManagerImpl.this.members = new ArrayList(newMembers);
                    needNotification = true;
                }
                RPCManagerImpl.this.coordinator = RPCManagerImpl.this.members != null && RPCManagerImpl.this.members.size() != 0 && ((Address)RPCManagerImpl.this.members.get(0)).equals(RPCManagerImpl.this.getLocalAddress());
                if (needNotification && RPCManagerImpl.this.notifier != null) {
                    InvocationContext ctx = RPCManagerImpl.this.spi.getInvocationContext();
                    RPCManagerImpl.this.notifier.notifyViewChange(newView, ctx);
                }
                RPCManagerImpl.this.coordinatorLock.notifyAll();
            }
        }

        public void suspect(Address suspected_mbr) {
        }

        public void block() {
            RPCManagerImpl.this.flushBlockGate.close();
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("Block received at " + RPCManagerImpl.this.getLocalAddress()));
            }
            RPCManagerImpl.this.notifier.notifyCacheBlocked(true);
            RPCManagerImpl.this.notifier.notifyCacheBlocked(false);
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("Block processed at " + RPCManagerImpl.this.getLocalAddress()));
            }
        }

        public void unblock() {
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("UnBlock received at " + RPCManagerImpl.this.getLocalAddress()));
            }
            RPCManagerImpl.this.notifier.notifyCacheUnblocked(true);
            RPCManagerImpl.this.notifier.notifyCacheUnblocked(false);
            if (RPCManagerImpl.this.log.isDebugEnabled()) {
                RPCManagerImpl.this.log.debug((Object)("UnBlock processed at " + RPCManagerImpl.this.getLocalAddress()));
            }
            RPCManagerImpl.this.flushBlockGate.open();
        }
    }
}

