/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.JDBCCacheLoader;

public class JDBCCacheLoaderConfig
extends AdjListJDBCCacheLoaderConfig {
    private static final long serialVersionUID = -8371846151643130271L;
    private static final Log log = LogFactory.getLog(JDBCCacheLoaderConfig.class);
    private String deleteNodeSql;
    private String recursiveChildrenSql;
    private String nodeCountSql;
    private String sqlConcat;
    private String startingWith;
    private String appendSeparator;
    private boolean batchEnabled = true;
    private long batchSize = 1000L;

    public JDBCCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        super(base);
        this.setClassName(JDBCCacheLoader.class.getName());
    }

    public JDBCCacheLoaderConfig() {
        this.setClassName(JDBCCacheLoader.class.getName());
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        this.sqlConcat = props.getProperty("cache.jdbc.sql-concat");
        this.disectSqlConcat();
        this.deleteNodeSql = this.constructDeleteNodeSql();
        this.recursiveChildrenSql = this.constructRecursiveChildrenSql();
        this.nodeCountSql = this.constructNodeCountSql();
        this.batchEnabled = Boolean.valueOf(props.getProperty("cache.jdbc.batch.enable"));
        if (props.containsKey("cache.jdbc.batch.size")) {
            this.batchSize = Long.parseLong(props.getProperty("cache.jdbc.batch.size"));
        }
    }

    public String getDeleteNodeSql() {
        if (this.startingWith == null || this.appendSeparator == null || this.deleteNodeSql == null) {
            this.disectSqlConcat();
            this.setDeleteNodeSql(this.constructDeleteNodeSql());
        }
        return this.deleteNodeSql;
    }

    public String getRecursiveChildrenSql() {
        if (this.startingWith == null || this.appendSeparator == null || this.recursiveChildrenSql == null) {
            this.disectSqlConcat();
            this.setRecursiveChildrenSql(this.constructRecursiveChildrenSql());
        }
        return this.recursiveChildrenSql;
    }

    public void setRecursiveChildrenSql(String recursiveChildrenSql) {
        this.recursiveChildrenSql = recursiveChildrenSql;
    }

    public String getNodeCountSql() {
        if (this.startingWith == null || this.appendSeparator == null || this.nodeCountSql == null) {
            this.disectSqlConcat();
            this.setNodeCountSql(this.constructNodeCountSql());
        }
        return this.nodeCountSql;
    }

    public void setNodeCountSql(String nodeCountSql) {
        this.nodeCountSql = nodeCountSql;
    }

    public String getSqlConcat() {
        return this.sqlConcat;
    }

    public void setSqlConcat(String sqlConcat) {
        this.testImmutability("sqlConcat");
        this.sqlConcat = sqlConcat;
    }

    public String getStartingWith() {
        return this.startingWith;
    }

    public void setStartingWith(String startingWith) {
        this.startingWith = startingWith;
    }

    public String getAppendSeparator() {
        return this.appendSeparator;
    }

    public void setAppendSeparator(String appendSeparator) {
        this.appendSeparator = appendSeparator;
    }

    public boolean isBatchEnabled() {
        return this.batchEnabled;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    private void disectSqlConcat() {
        if (this.sqlConcat == null) {
            log.info((Object)"Missing JDBCCacheLoader config 'cache.jdbc.sql-concat', using default value:'concat(1,2)'");
            this.sqlConcat = "concat(1,2)";
        }
        this.startingWith = this.sqlConcat.replace('1', '?').replace("2", "'%'");
        this.appendSeparator = this.sqlConcat.replace("1", this.fqnColumn).replace("2", "'/'");
    }

    private String constructNodeCountSql() {
        return "select count(*) from " + this.table;
    }

    private String constructRecursiveChildrenSql() {
        return "select " + this.fqnColumn + "," + this.nodeColumn + " from " + this.table + " where " + this.appendSeparator + " like " + this.startingWith;
    }

    private String constructDeleteNodeSql() {
        return "delete from " + this.table + " where " + this.appendSeparator + " like " + this.startingWith;
    }
}

