/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.pojo.annotation.Serializable;
import org.jboss.cache.pojo.annotation.Transient;
import org.jboss.cache.pojo.memory.FieldPersistentReference;
import org.jboss.cache.pojo.util.PrivilegedCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedType {
    private static final Set<Object> immediates = new HashSet<Object>(Arrays.asList(String.class, Boolean.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Character.class, Byte.class, Boolean.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Character.TYPE, Byte.TYPE, Class.class));
    private WeakReference<Class> type;
    private boolean immutable;
    private boolean immediate;
    private List<FieldPersistentReference> fields = new ArrayList<FieldPersistentReference>();
    private List<FieldPersistentReference> finalFields = new ArrayList<FieldPersistentReference>();
    private Map<String, FieldPersistentReference> fieldMap = new HashMap<String, FieldPersistentReference>();

    public CachedType() {
    }

    public CachedType(Class type) {
        this.type = new WeakReference<Class>(type);
        this.analyze();
    }

    public Class getType() {
        return (Class)this.type.get();
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public static boolean isImmediate(Class clazz) {
        return immediates.contains(clazz) || Enum.class.isAssignableFrom(clazz);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public List<FieldPersistentReference> getFields() {
        return this.fields;
    }

    public List<FieldPersistentReference> getFinalFields() {
        return this.finalFields;
    }

    public Field getField(String name) {
        FieldPersistentReference ref = this.fieldMap.get(name);
        if (ref == null) {
            return null;
        }
        return (Field)ref.get();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType().getName()).append(" {\n");
        sb.append("}, immutable =").append(this.immutable);
        return sb.toString();
    }

    private void analyze() {
        this.analyzeFields(this.getType());
        this.immediate = CachedType.isImmediate(this.getType());
    }

    private void analyzeFields(Class clazz) {
        if (clazz == null) {
            return;
        }
        this.analyzeFields(clazz.getSuperclass());
        Field[] classFields = clazz.getDeclaredFields();
        for (int i = 0; i < classFields.length; ++i) {
            Field f = classFields[i];
            if (CachedType.isNonReplicable(f)) continue;
            PrivilegedCode.setAccessible(f);
            FieldPersistentReference persistentRef = new FieldPersistentReference(f, 2);
            this.fields.add(persistentRef);
            this.fieldMap.put(f.getName(), persistentRef);
            if (!Modifier.isFinal(f.getModifiers())) continue;
            this.finalFields.add(persistentRef);
        }
    }

    public static boolean isNonReplicable(Field field) {
        int mods = field.getModifiers();
        return Modifier.isStatic(mods) || Modifier.isTransient(mods) || field.isAnnotationPresent(Transient.class);
    }

    public static boolean isSimpleAttribute(Field field) {
        return CachedType.isImmediate(field.getType()) || field.isAnnotationPresent(Serializable.class);
    }

    protected static String attributeName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    protected static boolean isGet(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    protected static boolean isSet(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }
}

