/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import org.jboss.reflect.plugins.AnnotationHolder;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.EnumConstantInfo;
import org.jboss.reflect.spi.EnumInfo;
import org.jboss.util.JBossStringBuilder;

public class EnumConstantInfoImpl
extends AnnotationHolder
implements EnumConstantInfo {
    private static final long serialVersionUID = 3761411923568243761L;
    protected String name;
    protected EnumInfo declaring;
    protected int hash = -1;

    public EnumConstantInfoImpl() {
    }

    public EnumConstantInfoImpl(String name, EnumInfo declaring) {
        this.name = name;
        this.declaring = declaring;
    }

    public EnumConstantInfoImpl(String name, EnumInfo declaring, AnnotationValue[] annotations) {
        super(annotations);
        this.name = name;
        this.declaring = declaring;
    }

    public String getName() {
        return this.name;
    }

    public EnumInfo getDeclaring() {
        return this.declaring;
    }

    public Object getValue() {
        return this.declaring.getEnumValue(this.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EnumConstantInfo)) {
            return false;
        }
        EnumConstantInfo enumConstantInfo = (EnumConstantInfo)o;
        if (!this.name.equals(enumConstantInfo.getName())) {
            return false;
        }
        return this.declaring.equals(enumConstantInfo.getDeclaring());
    }

    public int getHashCode() {
        int result = this.name.hashCode();
        result = 29 * result + this.declaring.hashCode();
        return result;
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" declaring=").append((Object)this.declaring);
    }
}

