/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import org.jboss.cache.Version;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class VersionConversionTest {
    public void testStringToShort() {
        try {
            Version.getVersionShort((String)"1.2.4SP1");
            AssertJUnit.fail((String)"Correctly did not accept versionString '1.2.4SP1'");
        }
        catch (IllegalArgumentException ok) {
            // empty catch block
        }
        try {
            Version.getVersionShort((String)"1.2.4 SP1");
            AssertJUnit.fail((String)"Correctly did not accept versionString '1.2.4 SP1'");
        }
        catch (IllegalArgumentException ok) {
            // empty catch block
        }
        try {
            Version.getVersionShort((String)"1.3.alpha");
            AssertJUnit.fail((String)"Correctly did not accept versionString '1.3.alpha'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        AssertJUnit.assertEquals((String)"MAX_SHORT correct", (short)Short.MAX_VALUE, (short)Version.getVersionShort((String)"15.31.63"));
        AssertJUnit.assertEquals((String)"0.0.1 correct", (int)1, (int)Version.getVersionShort((String)"0.0.1"));
        AssertJUnit.assertEquals((String)"0.1.0 correct", (short)((short)Math.pow(2.0, 6.0)), (short)Version.getVersionShort((String)"0.1.0"));
        AssertJUnit.assertEquals((String)"1.0 correct", (short)((short)Math.pow(2.0, 11.0)), (short)Version.getVersionShort((String)"1.0"));
        AssertJUnit.assertEquals((String)"1.0.1 correct", (int)((short)Math.pow(2.0, 11.0) + 1), (int)Version.getVersionShort((String)"1.0.1"));
        AssertJUnit.assertEquals((String)"1.1 correct", (short)((short)(Math.pow(2.0, 11.0) + Math.pow(2.0, 6.0))), (short)Version.getVersionShort((String)"1.1"));
        AssertJUnit.assertEquals((String)"1.1.1 correct", (int)((short)(Math.pow(2.0, 11.0) + Math.pow(2.0, 6.0)) + 1), (int)Version.getVersionShort((String)"1.1.1"));
        AssertJUnit.assertEquals((String)"2.0 correct", (short)((short)Math.pow(2.0, 12.0)), (short)Version.getVersionShort((String)"2.0"));
        AssertJUnit.assertEquals((String)"1.3.0.alpha correct", (short)((short)(Math.pow(2.0, 11.0) + Math.pow(2.0, 7.0) + Math.pow(2.0, 6.0))), (short)Version.getVersionShort((String)"1.3.0.alpha"));
        AssertJUnit.assertEquals((String)"1.3.0.RC1 correct", (short)((short)(Math.pow(2.0, 11.0) + Math.pow(2.0, 7.0) + Math.pow(2.0, 6.0))), (short)Version.getVersionShort((String)"1.3.0.RC1"));
        AssertJUnit.assertEquals((String)"1.3.0.SP1 correct", (short)((short)(Math.pow(2.0, 11.0) + Math.pow(2.0, 7.0) + Math.pow(2.0, 6.0))), (short)Version.getVersionShort((String)"1.3.0.SP1"));
        AssertJUnit.assertEquals((String)"1.2.4.SP2 correct", (short)124, (short)Version.getVersionShort((String)"1.2.4"));
        AssertJUnit.assertEquals((String)"1.2.4.SP2 correct", (short)1241, (short)Version.getVersionShort((String)"1.2.4.SP1"));
        AssertJUnit.assertEquals((String)"1.2.4.SP2 correct", (int)((short)(Math.pow(2.0, 11.0) + Math.pow(2.0, 7.0)) + 4), (int)Version.getVersionShort((String)"1.2.4.SP2"));
    }

    public void testShortToString() {
        AssertJUnit.assertEquals((String)"0.0.1 correct", (String)"0.0.1", (String)Version.getVersionString((short)Version.getVersionShort((String)"0.0.1")));
        AssertJUnit.assertEquals((String)"1.3.0 correct", (String)"1.3.0", (String)Version.getVersionString((short)Version.getVersionShort((String)"1.3.0")));
        AssertJUnit.assertEquals((String)"1.2.4 correct", (String)"1.2.4", (String)Version.getVersionString((short)124));
        AssertJUnit.assertEquals((String)"1.2.4.SP1 correct", (String)"1.2.4.SP1", (String)Version.getVersionString((short)1241));
        AssertJUnit.assertEquals((String)"1.2.4.SP2 correct", (String)"1.2.4.SP2", (String)Version.getVersionString((short)Version.getVersionShort((String)"1.2.4.SP2")));
    }

    public void testDefault() {
        short defaultShort = Version.getVersionShort();
        String versionString = Version.getVersionString((short)defaultShort);
        String versionToCompareAgainst = "3.0.0.CR4";
        versionToCompareAgainst = versionToCompareAgainst.replaceAll("[\\-\\.]\\w+$", "");
        AssertJUnit.assertEquals((String)"Round-trip conversion consistent", (String)versionToCompareAgainst, (String)versionString);
    }
}

