/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "pessimistic"}, sequential=true)
public class DeletedChildResurrectionTest {
    private CacheSPI<Object, Object> cache;
    private static final Fqn A_B = Fqn.fromString((String)"/a/b");
    private static final Fqn A = Fqn.fromString((String)"/a");
    private static final Fqn A_C = Fqn.fromString((String)"/a/c");
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String K2 = "k2";
    private static final String V2 = "v2";
    protected Configuration.NodeLockingScheme nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;
    protected NodeSPI root;
    protected TransactionManager txManager;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true), false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setCacheLoaderConfig(null);
        this.cache.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        this.configure(this.cache.getConfiguration());
        this.cache.start();
        this.root = this.cache.getRoot();
        this.txManager = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
        this.txManager = null;
        this.root = null;
    }

    protected void configure(Configuration c) {
    }

    public void testDeletedChildResurrection1() throws Exception {
        this.root.addChild(A_B).put((Object)KEY, (Object)VALUE);
        this.cache.put(A, (Object)KEY, (Object)VALUE);
        this.txManager.begin();
        this.root.removeChild(A);
        this.root.addChild(A);
        this.txManager.commit();
        assert (!this.root.hasChild(A_B));
        assert (null == this.cache.get(A, (Object)KEY));
        assert (this.cache.peek(A_B, true, true) == null);
        assert (this.root.hasChild(A));
    }

    public void testDeletedChildResurrection2() throws Exception {
        this.root.addChild(A_B).put((Object)KEY, (Object)VALUE);
        this.txManager.begin();
        this.root.removeChild(A);
        this.root.addChild(A_C).put((Object)K2, (Object)V2);
        this.txManager.commit();
        assert (!this.root.hasChild(A_B));
        assert (this.root.hasChild(A_C));
        assert (V2.equals(this.root.getChild(A_C).get((Object)K2)));
    }
}

