/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.LoadersElementParser;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "pessimistic"})
public class NodeMoveAPITest {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected static final Fqn A = Fqn.fromString((String)"/a");
    protected static final Fqn B = Fqn.fromString((String)"/b");
    protected static final Fqn C = Fqn.fromString((String)"/c");
    protected static final Fqn D = Fqn.fromString((String)"/d");
    protected static final Fqn E = Fqn.fromString((String)"/e");
    protected static final Object k = "key";
    protected static final Object vA = "valueA";
    protected static final Object vB = "valueB";
    protected static final Object vC = "valueC";
    protected static final Object vD = "valueD";
    protected static final Object vE = "valueE";
    protected Configuration.NodeLockingScheme nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;
    protected ThreadLocal<CacheSPI<Object, Object>> cacheTL = new ThreadLocal();
    protected ThreadLocal<TransactionManager> tmTL = new ThreadLocal();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache("configs/local-tx.xml", false);
        cache.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        cache.getConfiguration().setFetchInMemoryState(false);
        cache.getConfiguration().setEvictionConfig(null);
        this.configure(cache.getConfiguration());
        cache.start();
        this.cacheTL.set((CacheSPI<Object, Object>)cache);
        this.tmTL.set(cache.getTransactionManager());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TestingUtil.killCaches(new Cache[]{cache});
        this.cacheTL.set(null);
    }

    protected void configure(Configuration c) {
    }

    public void testBasicMove() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TransactionManager tm = this.tmTL.get();
        NodeSPI rootNode = cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put(k, vA);
        Node nodeB = rootNode.addChild(B);
        nodeB.put(k, vB);
        Node nodeC = nodeA.addChild(C);
        nodeC.put(k, vC);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertEquals((String)("" + nodeA), (Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        this.log.info((Object)("BEFORE MOVE " + cache));
        cache.move(nodeC.getFqn(), nodeB.getFqn());
        nodeC = cache.getNode(Fqn.fromRelativeFqn((Fqn)nodeB.getFqn(), (Fqn)C));
        this.log.info((Object)("POST MOVE " + cache));
        this.log.info((Object)("HC " + nodeC + " " + System.identityHashCode(nodeC)));
        Node x = cache.getRoot().getChild(Fqn.fromString((String)"b/c"));
        this.log.info((Object)("HC " + x + " " + System.identityHashCode(x)));
        AssertJUnit.assertEquals((String)("NODE C " + nodeC), (String)"/b/c", (String)nodeC.getFqn().toString());
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeB.hasChild(C));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((String)("B is parent of C: " + nodeB), (Object)nodeB, (Object)nodeC.getParent());
    }

    private Node<Object, Object> genericize(Node node) {
        return node;
    }

    public void testMoveWithChildren() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TransactionManager tm = this.tmTL.get();
        NodeSPI rootNode = cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        nodeA.put(k, vA);
        Node nodeB = rootNode.addChild(B);
        nodeB.put(k, vB);
        Node nodeC = nodeA.addChild(C);
        nodeC.put(k, vC);
        Node nodeD = nodeC.addChild(D);
        nodeD.put(k, vD);
        Node nodeE = nodeD.addChild(E);
        nodeE.put(k, vE);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)nodeD.get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)nodeE.get(k));
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeD.getParent());
        AssertJUnit.assertEquals((Object)nodeD, (Object)nodeE.getParent());
        this.log.info((Object)("move " + nodeC + " to " + nodeB));
        cache.move(nodeC.getFqn(), nodeB.getFqn());
        nodeC = nodeB.getChild(C);
        nodeD = nodeC.getChild(D);
        nodeE = nodeD.getChild(E);
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(A));
        AssertJUnit.assertTrue((boolean)rootNode.hasChild(B));
        AssertJUnit.assertFalse((boolean)rootNode.hasChild(C));
        AssertJUnit.assertFalse((boolean)nodeA.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeB.hasChild(C));
        AssertJUnit.assertTrue((boolean)nodeC.hasChild(D));
        AssertJUnit.assertTrue((boolean)nodeD.hasChild(E));
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)nodeD.get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)nodeE.get(k));
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeB, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeD.getParent());
        AssertJUnit.assertEquals((Object)nodeD, (Object)nodeE.getParent());
    }

    public void testTxCommit() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TransactionManager tm = this.tmTL.get();
        NodeSPI rootNode = cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
        tm.begin();
        cache.move(nodeB.getFqn(), Fqn.ROOT);
        tm.commit();
        nodeB = rootNode.getChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeA));
        AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeB));
        AssertJUnit.assertTrue((boolean)nodeA.getChildren().isEmpty());
    }

    public void testTxRollback() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TransactionManager tm = this.tmTL.get();
        NodeSPI rootNode = cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
        tm.begin();
        cache.move(nodeB.getFqn(), Fqn.ROOT);
        if (this.nodeLockingScheme == Configuration.NodeLockingScheme.PESSIMISTIC) {
            AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
            AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
            AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeA));
            AssertJUnit.assertTrue((boolean)rootNode.getChildren().contains(nodeB));
            AssertJUnit.assertTrue((boolean)nodeA.getChildren().isEmpty());
        }
        tm.rollback();
        nodeA = rootNode.getChild(A);
        nodeB = nodeA.getChild(B);
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)nodeA, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeA, rootNode.getChildren().iterator().next());
        AssertJUnit.assertEquals((Object)nodeB, nodeA.getChildren().iterator().next());
    }

    public void testWithCacheloaders() throws Exception {
        this.doCacheLoaderTest(false, false);
    }

    public void testWithPassivation() throws Exception {
        this.doCacheLoaderTest(true, false);
    }

    public void testWithCacheloadersTx() throws Exception {
        this.doCacheLoaderTest(false, true);
    }

    public void testWithPassivationTx() throws Exception {
        this.doCacheLoaderTest(true, true);
    }

    protected void doCacheLoaderTest(boolean pasv, boolean useTx) throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TransactionManager tm = this.tmTL.get();
        NodeSPI rootNode = cache.getRoot();
        cache.destroy();
        cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig(pasv, "/", DummyInMemoryCacheLoader.class.getName(), "debug=true", false, false, false, false));
        cache.start();
        DummyInMemoryCacheLoader loader = (DummyInMemoryCacheLoader)cache.getCacheLoaderManager().getCacheLoader();
        rootNode.put((Object)"key", (Object)"value");
        if (!pasv) {
            Map<Object, Object> m = loader.get(Fqn.ROOT);
            AssertJUnit.assertNotNull((String)"Should not be null", m);
            AssertJUnit.assertEquals((Object)"value", (Object)m.get("key"));
        }
        Node nodeA = rootNode.addChild(A);
        nodeA.put(k, vA);
        Node nodeB = rootNode.addChild(B);
        nodeB.put(k, vB);
        Node nodeC = nodeA.addChild(C);
        nodeC.put(k, vC);
        Node nodeD = nodeC.addChild(D);
        nodeD.put(k, vD);
        Node nodeE = nodeD.addChild(E);
        nodeE.put(k, vE);
        cache.evict(Fqn.ROOT, true);
        if (useTx) {
            tm.begin();
        }
        cache.move(nodeC.getFqn(), nodeB.getFqn());
        if (useTx) {
            tm.commit();
        }
        nodeA = rootNode.getChild(A);
        nodeB = rootNode.getChild(B);
        nodeC = nodeB.getChild(C);
        this.log.info((Object)"nodeC get child B ");
        nodeD = nodeC.getChild(D);
        this.log.info((Object)"nodeD get child E ");
        nodeE = nodeD.getChild(E);
        Fqn old_C = C;
        Fqn old_D = Fqn.fromRelativeFqn((Fqn)old_C, (Fqn)D);
        Fqn old_E = Fqn.fromRelativeFqn((Fqn)old_D, (Fqn)E);
        AssertJUnit.assertEquals((Object)vA, (Object)nodeA.get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)nodeB.get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)nodeC.get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)nodeD.get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)nodeE.get(k));
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeA.getParent());
        AssertJUnit.assertEquals((Object)rootNode, (Object)nodeB.getParent());
        AssertJUnit.assertEquals((Object)nodeB, (Object)nodeC.getParent());
        AssertJUnit.assertEquals((Object)nodeC, (Object)nodeD.getParent());
        AssertJUnit.assertEquals((Object)nodeD, (Object)nodeE.getParent());
        if (pasv) {
            cache.evict(Fqn.ROOT, true);
        }
        AssertJUnit.assertEquals((Object)vA, (Object)loader.get(nodeA.getFqn()).get(k));
        AssertJUnit.assertEquals((Object)vB, (Object)loader.get(nodeB.getFqn()).get(k));
        AssertJUnit.assertEquals((Object)vC, (Object)loader.get(nodeC.getFqn()).get(k));
        AssertJUnit.assertEquals((Object)vD, (Object)loader.get(nodeD.getFqn()).get(k));
        AssertJUnit.assertEquals((Object)vE, (Object)loader.get(nodeE.getFqn()).get(k));
        AssertJUnit.assertNull(loader.get(old_C));
        AssertJUnit.assertNull(loader.get(old_D));
        AssertJUnit.assertNull(loader.get(old_E));
    }

    public void testLocksDeepMove() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TransactionManager tm = this.tmTL.get();
        NodeSPI rootNode = cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeD = nodeB.addChild(D);
        Node nodeC = rootNode.addChild(C);
        Node nodeE = nodeC.addChild(E);
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
        tm.begin();
        cache.move(nodeC.getFqn(), nodeB.getFqn());
        this.checkLocksDeep();
        tm.commit();
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
    }

    public void testLocks() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        TransactionManager tm = this.tmTL.get();
        NodeSPI rootNode = cache.getRoot();
        Node nodeA = rootNode.addChild(A);
        Node nodeB = nodeA.addChild(B);
        Node nodeC = rootNode.addChild(C);
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
        tm.begin();
        cache.move(nodeC.getFqn(), nodeB.getFqn());
        this.checkLocks();
        tm.commit();
        this.assertNoLocks();
    }

    protected void checkLocks() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        AssertJUnit.assertEquals((String)"ROOT should have a RL, nodeC should have a RL, nodeA should have a RL, nodeB should have a WL", (int)4, (int)cache.getNumberOfLocksHeld());
    }

    protected void checkLocksDeep() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        AssertJUnit.assertEquals((String)"ROOT should have a RL, nodeC should have a RL, nodeA should have a RL, nodeB should have a WL, nodeD should have a WL", (int)6, (int)cache.getNumberOfLocksHeld());
    }

    protected void assertNoLocks() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
    }

    public void testConcurrency() throws InterruptedException {
        final CacheSPI<Object, Object> cache = this.cacheTL.get();
        NodeSPI rootNode = cache.getRoot();
        int N = 3;
        int loops = 64;
        Fqn FQN_A = A;
        Fqn FQN_B = B;
        Fqn FQN_C = C;
        Fqn FQN_D = D;
        Fqn FQN_E = E;
        Fqn FQN_X = Fqn.fromString((String)"/x");
        Fqn FQN_Y = Fqn.fromString((String)"/y");
        final Node[] NODES = new Node[]{rootNode.addChild(FQN_A), rootNode.addChild(FQN_B), rootNode.addChild(FQN_C), rootNode.addChild(FQN_D), rootNode.addChild(FQN_E)};
        final Node NODE_X = this.genericize(NODES[0]).addChild(FQN_X);
        final Node NODE_Y = this.genericize(NODES[1]).addChild(FQN_Y);
        Thread[] movers = new Thread[3];
        final CountDownLatch latch = new CountDownLatch(1);
        final Random r = new Random();
        for (int i = 0; i < 3; ++i) {
            movers[i] = new Thread("Mover-" + i){

                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (int counter = 0; counter < 64; ++counter) {
                        System.out.println(this.getName() + ": Attempt " + counter);
                        try {
                            cache.move(NODE_X.getFqn(), NODES[r.nextInt(NODES.length)].getFqn());
                        }
                        catch (NodeNotExistsException e) {
                            // empty catch block
                        }
                        TestingUtil.sleepRandom(250);
                        try {
                            cache.move(NODE_Y.getFqn(), NODES[r.nextInt(NODES.length)].getFqn());
                        }
                        catch (NodeNotExistsException nodeNotExistsException) {
                            // empty catch block
                        }
                        TestingUtil.sleepRandom(250);
                    }
                }
            };
            movers[i].start();
        }
        latch.countDown();
        for (Thread t : movers) {
            t.join();
        }
        AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
        boolean found_x = false;
        boolean found_x_again = false;
        for (Node erased : NODES) {
            Node<Object, Object> n = this.genericize(erased);
            if (!found_x) {
                found_x = n.hasChild(FQN_X);
                continue;
            }
            found_x_again = found_x_again || n.hasChild(FQN_X);
        }
        boolean found_y = false;
        boolean found_y_again = false;
        for (Node erased : NODES) {
            Node<Object, Object> n = this.genericize(erased);
            if (!found_y) {
                found_y = n.hasChild(FQN_Y);
                continue;
            }
            found_y_again = found_y_again || n.hasChild(FQN_Y);
        }
        AssertJUnit.assertTrue((String)"Should have found x", (boolean)found_x);
        AssertJUnit.assertTrue((String)"Should have found y", (boolean)found_y);
        AssertJUnit.assertFalse((String)"Should have only found x once", (boolean)found_x_again);
        AssertJUnit.assertFalse((String)"Should have only found y once", (boolean)found_y_again);
    }

    public void testMoveInSamePlace() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        NodeSPI rootNode = cache.getRoot();
        Fqn FQN_X = Fqn.fromString((String)"/x");
        Node aNode = rootNode.addChild(A);
        Node xNode = aNode.addChild(FQN_X);
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
        cache.move(xNode.getFqn(), aNode.getFqn());
        AssertJUnit.assertEquals((int)aNode.getChildren().size(), (int)1);
        assert (0 == cache.getNumberOfLocksHeld());
    }

    protected CacheLoaderConfig getSingleCacheLoaderConfig(boolean passivation, String preload, String cacheloaderClass, String properties, boolean async, boolean fetchPersistentState, boolean shared, boolean purgeOnStartup) throws Exception {
        String xml = "      <loaders passivation=\"" + passivation + "\" shared=\"" + shared + "\">\n" + "         <preload>\n" + "            <node fqn=\"" + preload + "\"/>\n" + "         </preload>\n" + "         <loader class=\"" + cacheloaderClass + "\" async=\"" + async + "\" fetchPersistentState=\"" + fetchPersistentState + "\"\n" + "                     purgeOnStartup=\"" + purgeOnStartup + "\">\n" + "            <properties>\n" + properties + "            </properties>\n" + "         </loader>\n" + "      </loaders>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        LoadersElementParser elementParser = new LoadersElementParser();
        return elementParser.parseLoadersElement(element);
    }

    protected boolean isOptimistic() {
        return false;
    }
}

