/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.nodevalidity;

import java.util.Collections;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotValidException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public abstract class NodeValidityTestBase {
    protected Configuration.NodeLockingScheme nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;
    protected boolean clustered = true;
    protected boolean invalidation = false;
    protected ThreadLocal<Cache<String, String>> observerTL = new ThreadLocal();
    protected ThreadLocal<Cache<String, String>> modifierTL = new ThreadLocal();
    protected static final Fqn parent = Fqn.fromString((String)"/parent");
    protected static final Fqn child = Fqn.fromString((String)"/parent/child");
    protected static final String K = "k";
    protected static final String V = "v";

    protected abstract Cache<String, String> createObserver();

    protected abstract Cache<String, String> createModifier();

    protected void nodeLockingSchemeSpecificSetup(Configuration c) {
        c.setNodeLockingScheme(this.nodeLockingScheme);
        if (this.isOptimistic()) {
            c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
            c.setSyncCommitPhase(true);
            c.setSyncRollbackPhase(true);
        }
    }

    protected boolean isOptimistic() {
        return this.nodeLockingScheme == Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    @BeforeMethod
    public void setUp() {
        Cache<String, String> observer = this.createObserver();
        Cache<String, String> modifier = this.createModifier();
        this.observerTL.set(observer);
        this.modifierTL.set(modifier);
        if (this.clustered) {
            TestingUtil.blockUntilViewsReceived(60000L, observer, modifier);
        }
    }

    @AfterMethod
    public void tearDown() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        TestingUtil.killCaches(observer, modifier);
        this.observerTL.set(null);
        this.modifierTL.set(null);
    }

    public void testRemoval() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        observer.put(parent, (Object)K, (Object)V);
        Node obsNode = observer.getRoot().getChild(parent);
        assert (((String)obsNode.get((Object)K)).equals(V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        modifier.removeNode(parent);
        assert (!obsNode.isValid()) : "Should no longer be valid";
    }

    public void testRemovalWithChildren() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        observer.put(child, (Object)K, (Object)V);
        Node obsParentNode = observer.getRoot().getChild(parent);
        Node obsChildNode = observer.getRoot().getChild(child);
        assert (((String)obsChildNode.get((Object)K)).equals(V)) : "Data should be in the node.";
        assert (obsChildNode.isValid()) : "Node should be valid";
        assert (obsParentNode.isValid()) : "Node should be valid";
        modifier.removeNode(parent);
        assert (!obsParentNode.isValid()) : "Should no longer be valid";
        assert (!obsChildNode.isValid()) : "Should no longer be valid";
    }

    public void testMove() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        Fqn newParent = Fqn.fromString((String)"/newParent/parent");
        observer.put(parent, (Object)K, (Object)V);
        Node obsNode = observer.getRoot().getChild(parent);
        assert (((String)obsNode.get((Object)K)).equals(V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        modifier.getRoot().addChild(newParent);
        modifier.move(parent, newParent.getParent());
        if (this.isOptimistic()) assert (!obsNode.isValid()) : "Should no longer be valid";
        assert (observer.getRoot().getChild(newParent).isValid()) : "Should be valid";
    }

    public void testMoveWithChildren() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        Fqn newParent = Fqn.fromString((String)"/newParent/parent");
        Fqn newChild = Fqn.fromString((String)"/newParent/parent/child");
        observer.put(child, (Object)K, (Object)V);
        Node obsParentNode = observer.getRoot().getChild(parent);
        Node obsChildNode = observer.getRoot().getChild(child);
        assert (((String)obsChildNode.get((Object)K)).equals(V)) : "Data should be in the node.";
        assert (obsChildNode.isValid()) : "Node should be valid";
        assert (obsParentNode.isValid()) : "Node should be valid";
        modifier.getRoot().addChild(newParent);
        modifier.move(parent, newParent.getParent());
        if (this.isOptimistic()) {
            assert (!obsParentNode.isValid()) : "Should no longer be valid";
            assert (!obsChildNode.isValid()) : "Should no longer be valid";
        }
        assert (observer.getRoot().getChild(newParent).isValid()) : "Should be valid";
        assert (observer.getRoot().getChild(newChild).isValid()) : "Should be valid";
    }

    public void testEvict() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        observer.put(parent, (Object)K, (Object)V);
        Node obsNode = observer.getRoot().getChild(parent);
        assert (((String)obsNode.get((Object)K)).equals(V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        observer.evict(parent, false);
        assert (!obsNode.isValid()) : "Node should not be valid";
    }

    public void testOperationsOnInvalidNode() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        observer.put(parent, (Object)K, (Object)V);
        Node obsNode = observer.getRoot().getChild(parent);
        assert (((String)obsNode.get((Object)K)).equals(V)) : "Data should be in the node.";
        assert (obsNode.isValid()) : "Node should be valid";
        modifier.removeNode(parent);
        assert (!obsNode.isValid()) : "Node should not be valid";
        try {
            obsNode.get((Object)K);
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.put((Object)K, (Object)"v2");
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.remove((Object)K);
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.clearData();
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.putAll(Collections.singletonMap(K, "v2"));
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.getKeys();
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.hasChild((Object)"Something");
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.removeChild((Object)"Something");
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.addChild(child);
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
        try {
            obsNode.getChildrenNames();
            assert (false) : "Should fail";
        }
        catch (NodeNotValidException good) {
            // empty catch block
        }
    }

    public void testExistenceOfTombstones() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        CacheSPI modifierImpl = (CacheSPI)modifier;
        CacheSPI observerImpl = (CacheSPI)observer;
        modifier.put(parent, (Object)K, (Object)V);
        modifier.removeNode(parent);
        if (this.isOptimistic() && this.invalidation) {
            NodeSPI modifierTombstone = modifierImpl.peek(parent, true, true);
            NodeSPI observerTombstone = observerImpl.peek(parent, true, true);
            assert (modifierTombstone != null) : "Modifier tombstone should not be null";
            assert (observerTombstone != null) : "Observer tombstone should not be null";
            assert (!modifierTombstone.isValid()) : "Should not be valid";
            assert (!observerTombstone.isValid()) : "Should not be valid";
            assert (((DefaultDataVersion)modifierTombstone.getVersion()).getRawVersion() == 2L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)observerTombstone.getVersion()).getRawVersion() == 2L) : "Tombstone should be versioned";
        } else {
            assert (modifierImpl.peek(parent, true, true) == null) : "Tombstone should not exist";
            assert (observerImpl.peek(parent, true, true) == null) : "Tombstone should not exist";
        }
    }

    public void testExistenceOfTombstonesWithChildren() {
        Cache<String, String> observer = this.observerTL.get();
        Cache<String, String> modifier = this.modifierTL.get();
        CacheSPI modifierImpl = (CacheSPI)modifier;
        CacheSPI observerImpl = (CacheSPI)observer;
        modifier.put(child, (Object)K, (Object)V);
        modifier.removeNode(parent);
        if (this.isOptimistic() && this.invalidation) {
            NodeSPI modifierParentTombstone = modifierImpl.peek(parent, true, true);
            NodeSPI observerParentTombstone = observerImpl.peek(parent, true, true);
            NodeSPI modifierChildTombstone = modifierImpl.peek(child, true, true);
            NodeSPI observerChildTombstone = observerImpl.peek(child, true, true);
            assert (modifierParentTombstone != null) : "Modifier parent tombstone should not be null";
            assert (observerParentTombstone != null) : "Observer parent tombstone should not be null";
            assert (modifierChildTombstone != null) : "Modifier child tombstone should not be null";
            assert (observerChildTombstone != null) : "Observer child tombstone should not be null";
            assert (!modifierParentTombstone.isValid()) : "Should not be valid";
            assert (!observerParentTombstone.isValid()) : "Should not be valid";
            assert (!modifierChildTombstone.isValid()) : "Should not be valid";
            assert (!observerChildTombstone.isValid()) : "Should not be valid";
            assert (((DefaultDataVersion)modifierParentTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)observerParentTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)modifierChildTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
            assert (((DefaultDataVersion)observerChildTombstone.getVersion()).getRawVersion() == 1L) : "Tombstone should be versioned";
        } else {
            assert (modifierImpl.peek(parent, true, true) == null) : "Tombstone should not exist";
            assert (observerImpl.peek(parent, true, true) == null) : "Tombstone should not exist";
            assert (modifierImpl.peek(child, true, true) == null) : "Tombstone should not exist";
            assert (observerImpl.peek(child, true, true) == null) : "Tombstone should not exist";
        }
    }
}

