/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public abstract class BuddyReplicationTestsBase {
    protected ThreadLocal<List<CacheSPI<Object, Object>>> cachesTL = new ThreadLocal();
    protected BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();
    protected static final int VIEW_BLOCK_TIMEOUT = 5000;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        System.out.println("***** TEARING DOWN *****");
        System.setProperty("org.jboss.cache.shutdown.force", "true");
        List<CacheSPI<Object, Object>> caches = this.cachesTL.get();
        if (caches != null) {
            for (CacheSPI<Object, Object> c : caches) {
                if (c == null || c.getBuddyManager() == null) continue;
                c.getBuddyManager().stop();
            }
            for (CacheSPI<Object, Object> c : caches) {
                CacheLoaderManager clm;
                if (c == null) continue;
                TransactionManager tm = c.getTransactionManager();
                if (tm != null) {
                    try {
                        if (tm.getTransaction() != null) {
                            tm.rollback();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((clm = c.getCacheLoaderManager()) != null) {
                    CacheLoader cl = c.getCacheLoaderManager().getCacheLoader();
                    try {
                        if (cl != null) {
                            cl.remove(Fqn.ROOT);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                c.stop();
                Object var3_3 = null;
            }
        }
        this.cachesTL.set(null);
        System.gc();
        new UnitTestCacheFactory().cleanUp();
    }

    protected CacheSPI<Object, Object> createCache(int numBuddies, String buddyPoolName) throws Exception {
        return this.createCache(numBuddies, buddyPoolName, false, true);
    }

    protected CacheSPI<?, ?> createCache(int numBuddies, String buddyPoolName, boolean useDataGravitation) throws Exception {
        return this.createCache(numBuddies, buddyPoolName, useDataGravitation, true);
    }

    protected CacheSPI<Object, Object> createCache(int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean start) throws Exception {
        return this.createCache(false, numBuddies, buddyPoolName, useDataGravitation, true, start);
    }

    protected CacheSPI<Object, Object> createCache(boolean optimisticLocks, int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean start) throws Exception {
        return this.createCache(optimisticLocks, numBuddies, buddyPoolName, useDataGravitation, true, start);
    }

    protected CacheSPI<?, ?> createCache(int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean removeOnFind, boolean start) throws Exception {
        return this.createCache(false, numBuddies, buddyPoolName, useDataGravitation, removeOnFind, start);
    }

    protected CacheSPI<Object, Object> createCache(boolean optimisticLocks, int numBuddies, String buddyPoolName, boolean useDataGravitation, boolean removeOnFind, boolean start) throws Exception {
        CacheSPI c = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC, false, false, true), false);
        String threadId = Thread.currentThread().getName();
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        if (buddyPoolName != null) {
            brc.setBuddyPoolName(buddyPoolName);
        }
        brc.setEnabled(true);
        brc.setBuddyCommunicationTimeout(500000);
        brc.setDataGravitationRemoveOnFind(removeOnFind);
        brc.setDataGravitationSearchBackupTrees(true);
        brc.setAutoDataGravitation(useDataGravitation);
        NextMemberBuddyLocatorConfig nextMemberBuddyLocatorConfig = new NextMemberBuddyLocatorConfig();
        nextMemberBuddyLocatorConfig.setNumBuddies(numBuddies);
        brc.setBuddyLocatorConfig((BuddyReplicationConfig.BuddyLocatorConfig)nextMemberBuddyLocatorConfig);
        c.getConfiguration().setBuddyReplicationConfig(brc);
        c.getConfiguration().setFetchInMemoryState(true);
        c.getConfiguration().setNodeLockingScheme(optimisticLocks ? Configuration.NodeLockingScheme.OPTIMISTIC : this.getNonOptimisticLockingScheme());
        c.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        c.getConfiguration().setSyncCommitPhase(true);
        this.configureMultiplexer((Cache)c);
        if (start) {
            c.start();
            this.validateMultiplexer((Cache)c);
        }
        return c;
    }

    protected Configuration.NodeLockingScheme getNonOptimisticLockingScheme() {
        return Configuration.NodeLockingScheme.PESSIMISTIC;
    }

    protected void configureMultiplexer(Cache cache) throws Exception {
    }

    protected void validateMultiplexer(Cache cache) {
        AssertJUnit.assertFalse((String)"Cache is not using multiplexer", (boolean)cache.getConfiguration().isUsingMultiplexer());
    }

    protected List<CacheSPI<Object, Object>> createCaches(int numCaches, boolean useBuddyPool) throws Exception {
        return this.createCaches(1, numCaches, useBuddyPool, false);
    }

    protected List<CacheSPI<Object, Object>> createCaches(int numCaches, boolean useBuddyPool, boolean useDataGravitation, boolean optimisticLocks) throws Exception {
        return this.createCaches(1, numCaches, useBuddyPool, useDataGravitation, optimisticLocks);
    }

    protected List<CacheSPI<Object, Object>> createCaches(int numCaches, boolean useBuddyPool, boolean useDataGravitation) throws Exception {
        return this.createCaches(1, numCaches, useBuddyPool, useDataGravitation);
    }

    protected List<CacheSPI<Object, Object>> createCachesWithCacheLoader(int numCaches, boolean useDataGravitation, boolean removeOnFind, boolean passivation) throws Exception {
        return this.createCachesWithCacheLoader(numCaches, useDataGravitation, removeOnFind, passivation, false);
    }

    protected List<CacheSPI<Object, Object>> createCachesWithCacheLoader(int numCaches, boolean useDataGravitation, boolean removeOnFind, boolean passivation, boolean fetchPersistent) throws Exception {
        ArrayList<CacheSPI<Object, Object>> caches = new ArrayList<CacheSPI<Object, Object>>();
        for (int i = 0; i < numCaches; ++i) {
            caches.add(this.createCacheWithCacheLoader(useDataGravitation, removeOnFind, passivation, fetchPersistent, true));
        }
        TestingUtil.blockUntilViewsReceived(caches.toArray(new Cache[0]), 5000L);
        TestingUtil.sleepThread(this.getSleepTimeout());
        return caches;
    }

    protected CacheSPI createCacheWithCacheLoader(boolean useDataGravitation, boolean removeOnFind, boolean passivation, boolean fetchPersistent, boolean start) throws Exception {
        CacheSPI<?, ?> cache = this.createCache(1, null, useDataGravitation, removeOnFind, false);
        CacheLoaderConfig config = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummyInMemoryCacheLoader.class.getName());
        iclc.setFetchPersistentState(fetchPersistent);
        config.addIndividualCacheLoaderConfig(iclc);
        config.setShared(false);
        config.setPassivation(passivation);
        cache.getConfiguration().setCacheLoaderConfig(config);
        if (start) {
            cache.start();
        }
        return cache;
    }

    protected List<CacheSPI<Object, Object>> createCaches(int numBuddies, int numCaches, boolean useBuddyPool) throws Exception {
        return this.createCaches(numBuddies, numCaches, useBuddyPool, false);
    }

    protected List<CacheSPI<Object, Object>> createCaches(int numBuddies, int numCaches, boolean useBuddyPool, boolean useDataGravitation) throws Exception {
        return this.createCaches(numBuddies, numCaches, useBuddyPool, useDataGravitation, false);
    }

    protected List<CacheSPI<Object, Object>> createCaches(int numBuddies, int numCaches, boolean useBuddyPool, boolean useDataGravitation, boolean optimisticLocks) throws Exception {
        return this.createCaches(numBuddies, numCaches, useBuddyPool, useDataGravitation, optimisticLocks, true);
    }

    protected List<CacheSPI<Object, Object>> createCaches(int numBuddies, int numCaches, boolean useBuddyPool, boolean useDataGravitation, boolean optimisticLocks, boolean start) throws Exception {
        ArrayList<CacheSPI<Object, Object>> caches = new ArrayList<CacheSPI<Object, Object>>(numCaches);
        for (int i = 0; i < numCaches; ++i) {
            caches.add(this.createCache(optimisticLocks, numBuddies, useBuddyPool ? Character.toString((char)(65 + i)) : null, useDataGravitation, start));
        }
        if (start) {
            TestingUtil.blockUntilViewsReceived(caches.toArray(new Cache[0]), 5000L);
            TestingUtil.sleepThread(this.getSleepTimeout());
        }
        return caches;
    }

    protected void printBuddyGroup(Cache cache) {
        BuddyManager bm = ((CacheSPI)cache).getBuddyManager();
        BuddyGroup bg = bm.buddyGroup;
        System.out.println("*** " + bg);
        System.out.println("    Groups I participate in: " + bm.buddyGroupsIParticipateIn.keySet());
    }

    protected int getSleepTimeout() {
        return 1000;
    }

    protected void assertIsBuddy(Cache dataOwner, Cache buddy, boolean onlyBuddy) {
        Address dataOwnerLocalAddress = dataOwner.getLocalAddress();
        Address buddyLocalAddress = buddy.getLocalAddress();
        System.out.println("*** assert with groups.  Testing that " + buddyLocalAddress + " is a buddy for owner " + dataOwnerLocalAddress + " only buddy? " + onlyBuddy);
        this.printBuddyGroup(dataOwner);
        BuddyManager dataOwnerBuddyManager = ((CacheSPI)dataOwner).getBuddyManager();
        BuddyManager buddyBuddyManager = ((CacheSPI)buddy).getBuddyManager();
        if (onlyBuddy) {
            AssertJUnit.assertEquals((String)"Should only have one buddy", (int)1, (int)dataOwnerBuddyManager.getBuddyAddresses().size());
        }
        AssertJUnit.assertTrue((String)(buddyLocalAddress + " should be a buddy to " + dataOwnerLocalAddress), (boolean)dataOwnerBuddyManager.getBuddyAddresses().contains(buddyLocalAddress));
        BuddyGroup group = (BuddyGroup)buddyBuddyManager.buddyGroupsIParticipateIn.get(dataOwnerLocalAddress);
        System.out.println("*** Groups I participate in: " + buddyBuddyManager.buddyGroupsIParticipateIn);
        System.out.println("*** Buddy's version of dataOwner's group " + group);
        AssertJUnit.assertTrue((String)"buddy's list of groups it participates in should contain data owner's group name", (boolean)buddyBuddyManager.buddyGroupsIParticipateIn.containsKey(dataOwnerLocalAddress));
        if (onlyBuddy) {
            AssertJUnit.assertEquals((int)1, (int)group.getBuddies().size());
        }
        AssertJUnit.assertTrue((String)(buddyLocalAddress + " should be a buddy to " + group.getGroupName()), (boolean)group.getBuddies().contains(buddyLocalAddress));
    }

    protected void assertNoLocks(List<CacheSPI<Object, Object>> caches) {
        for (CacheSPI<Object, Object> cache : caches) {
            if (cache == null) continue;
            AssertJUnit.assertEquals((int)0, (int)cache.getNumberOfLocksHeld());
        }
    }
}

