/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.TestContextBase;
import org.jboss.cache.commands.legacy.write.PessPutDataMapCommand;
import org.jboss.cache.mock.NodeSpiMock;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.transaction.GlobalTransaction;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class PutDataMapCommandTest
extends TestContextBase {
    Fqn testFqn = Fqn.fromString((String)"/testfqn");
    PessPutDataMapCommand command;
    GlobalTransaction gtx;
    Notifier notifier;
    DataContainer container;
    Map dataMap;
    IMocksControl control;
    NodeSpiMock node;
    InvocationContext ctx;

    @BeforeMethod
    protected void setUp() {
        this.gtx = new GlobalTransaction();
        this.dataMap = new HashMap();
        this.command = new PessPutDataMapCommand(this.gtx, this.testFqn, this.dataMap);
        this.control = EasyMock.createStrictControl();
        this.notifier = (Notifier)this.control.createMock(Notifier.class);
        this.container = (DataContainer)this.control.createMock(DataContainer.class);
        this.command.initialize(this.notifier, this.container);
        this.node = new NodeSpiMock(this.testFqn);
        this.node.put("k", "v");
        this.ctx = this.createLegacyInvocationContext(this.container);
    }

    public void testAddDataNoErase() {
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn((Object)this.node);
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn((Object)this.node);
        this.dataMap.put("k2", "v2");
        HashMap expected = new HashMap(this.dataMap);
        expected.putAll(this.node.getDataDirect());
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.testFqn, true, NodeModifiedEvent.ModificationType.PUT_MAP, this.node.getData(), this.ctx);
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.testFqn, false, NodeModifiedEvent.ModificationType.PUT_MAP, expected, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx)) : "null result is always expected";
        assert (this.command.oldData.size() == 1);
        assert (this.command.oldData.get("k").equals("v"));
        this.control.verify();
    }

    public void testRollbackNonexistentNode() {
        EasyMock.expect((Object)this.container.peek(this.testFqn, false, true)).andReturn(null);
        this.control.replay();
        this.command.rollback();
        this.control.verify();
    }
}

