/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.EvictionElementParser;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"}, sequential=false)
public class FIFOConfigurationTest {
    public void testXMLParse() throws Exception {
        FIFOAlgorithmConfig config = new FIFOAlgorithmConfig();
        String xml = "<region name=\"abc\"><property name=\"maxNodes\" value=\"1000\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)1000, (int)config.getMaxNodes());
    }

    public void testXMLParse2() throws Exception {
        FIFOAlgorithmConfig config = new FIFOAlgorithmConfig();
        String xml = "<region name=\"abc\"></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        assert (config.getMaxNodes() == -1);
        assert (config.getMinTimeToLive() == -1L);
    }

    public void testXMLParse3() throws Exception {
        FIFOAlgorithmConfig config = new FIFOAlgorithmConfig();
        String xml = "<region><property name=\"maxNodes\" value=\"1000\"></property></region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        try {
            EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
            config.validate();
        }
        catch (ConfigurationException ce) {
            AssertJUnit.assertTrue((String)"Configure Exception properly thrown", (boolean)true);
        }
    }
}

