/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.NullEvictionAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class RegionManagerTest {
    private final Fqn DEFAULT_REGION = Fqn.ROOT;
    Fqn A_B_C = Fqn.fromString((String)"/a/b/c");
    Fqn A_B = Fqn.fromString((String)"/a/b");
    Fqn A_BC = Fqn.fromString((String)"/a/bc");
    Fqn AOP = Fqn.fromString((String)"/aop");
    EvictionRegionConfig config = new EvictionRegionConfig(null, (EvictionAlgorithmConfig)new NullEvictionAlgorithmConfig());

    public void testCreateRegion() {
        RegionManagerImpl regionManager = new RegionManagerImpl();
        regionManager.injectDependencies(null, null, null, null, null, new RegionRegistry());
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.DEFAULT_REGION, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.A_B_C, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.AOP, true).setEvictionRegionConfig(this.config);
        List regions = regionManager.getAllRegions(Region.Type.ANY);
        AssertJUnit.assertEquals((String)"Region size ", (int)4, (int)regions.size());
    }

    public void testCreateRegion2() {
        RegionManagerImpl regionManager = new RegionManagerImpl();
        regionManager.injectDependencies(null, null, null, null, null, new RegionRegistry());
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.A_B_C, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.DEFAULT_REGION, true).setEvictionRegionConfig(this.config);
        List regions = regionManager.getAllRegions(Region.Type.ANY);
        AssertJUnit.assertEquals((String)"Region size ", (int)3, (int)regions.size());
        AssertJUnit.assertEquals((String)"Region 0", (Object)this.DEFAULT_REGION, (Object)((Region)regions.get(0)).getFqn());
        AssertJUnit.assertEquals((String)"Region 1 ", (Object)this.A_B, (Object)((Region)regions.get(1)).getFqn());
        AssertJUnit.assertEquals((String)"Region 2 ", (Object)this.A_B_C, (Object)((Region)regions.get(2)).getFqn());
        Region region = regionManager.getRegion("/a/b/c/d", false);
        AssertJUnit.assertNotNull((String)"Region ", (Object)region);
        AssertJUnit.assertEquals((String)"Region ", (Object)this.A_B_C, (Object)region.getFqn());
        region = regionManager.getRegion(this.A_B, false);
        AssertJUnit.assertNotNull((String)"Region ", (Object)region);
        AssertJUnit.assertEquals((String)"Region ", (Object)this.A_B, (Object)region.getFqn());
        region = regionManager.getRegion("/a", false);
        AssertJUnit.assertNotNull((String)"Region ", (Object)region);
        AssertJUnit.assertEquals((String)"Region ", (Object)this.DEFAULT_REGION, (Object)region.getFqn());
    }

    public void testNoDefaultRegion() {
        RegionManagerImpl regionManager = new RegionManagerImpl();
        regionManager.injectDependencies(null, null, null, null, null, new RegionRegistry());
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.A_B_C, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(Fqn.fromString((String)"/a"), Region.Type.EVICTION, false);
    }

    public void testGetRegion() {
        RegionManagerImpl regionManager = new RegionManagerImpl();
        regionManager.injectDependencies(null, null, null, null, null, new RegionRegistry());
        regionManager.setUsingEvictions(true);
        regionManager.getRegion(this.DEFAULT_REGION, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.A_BC, true).setEvictionRegionConfig(this.config);
        regionManager.getRegion(this.A_B, true).setEvictionRegionConfig(this.config);
        Region region = regionManager.getRegion(this.A_BC, true);
        AssertJUnit.assertNotSame((String)"Region ", (Object)this.DEFAULT_REGION, (Object)region.getFqn());
    }

    public void testRegionOrdering() throws Exception {
        Fqn A_B_C_D_E = Fqn.fromString((String)"/a/b/c/d/e/");
        Fqn A_B_C_D = Fqn.fromString((String)"/a/b/c/d/");
        RegionManagerImpl rm = new RegionManagerImpl();
        rm.injectDependencies(null, null, null, null, null, new RegionRegistry());
        rm.setUsingEvictions(true);
        rm.getRegion(this.DEFAULT_REGION, true).setEvictionRegionConfig(this.config);
        rm.getRegion(A_B_C_D_E, true).setEvictionRegionConfig(this.config);
        rm.getRegion(A_B_C_D, true).setEvictionRegionConfig(this.config);
        rm.getRegion(this.A_B_C, true).setEvictionRegionConfig(this.config);
        Region region = rm.getRegion("/a/b/c/d/e/f", false);
        Region region2 = rm.getRegion("/e/f/g", false);
        AssertJUnit.assertEquals((Object)A_B_C_D_E, (Object)region.getFqn());
        AssertJUnit.assertEquals((Object)this.DEFAULT_REGION, (Object)region2.getFqn());
        List regions = rm.getAllRegions(Region.Type.ANY);
        block6: for (int i = 0; i < regions.size(); ++i) {
            switch (i) {
                case 0: {
                    AssertJUnit.assertEquals((Object)this.DEFAULT_REGION, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                case 1: {
                    AssertJUnit.assertEquals((Object)this.A_B_C, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                case 2: {
                    AssertJUnit.assertEquals((Object)A_B_C_D, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                case 3: {
                    AssertJUnit.assertEquals((Object)A_B_C_D_E, (Object)((Region)regions.get(i)).getFqn());
                    continue block6;
                }
                default: {
                    AssertJUnit.fail((String)"This error condition should never be reached");
                }
            }
        }
    }
}

