/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true)
public class VersionInconsistencyTest {
    private Cache cache1;
    private Cache cache2;
    private TransactionManager tm1;
    private TransactionManager tm2;
    private Fqn node = Fqn.fromString((String)"/a");

    @BeforeMethod
    public void setUp() {
        Configuration c1 = new Configuration();
        Configuration c2 = new Configuration();
        c1.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        c2.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        c1.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        c2.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        c1.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        c2.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache1 = new UnitTestCacheFactory().createCache(c1, false);
        this.cache2 = new UnitTestCacheFactory().createCache(c2, false);
        this.cache1.start();
        this.cache2.start();
        this.tm1 = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.tm2 = this.cache2.getConfiguration().getRuntimeConfig().getTransactionManager();
        TestingUtil.blockUntilViewsReceived(1000L, this.cache1, this.cache2);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache1, this.cache2);
        this.cache1 = null;
        this.cache2 = null;
    }

    public void dataInconsistency() throws Exception {
        this.tm1.begin();
        this.cache1.put(this.node, (Object)"k", (Object)"v-older");
        Transaction t1 = this.tm1.suspend();
        this.tm2.begin();
        this.cache2.put(this.node, (Object)"k", (Object)"v-newer");
        this.tm2.commit();
        this.tm1.resume(t1);
        try {
            this.tm1.commit();
            assert (false) : "Should not be allowed to commit with older data!!";
        }
        catch (Exception good) {
            // empty catch block
        }
        Object val = this.cache1.get(this.node, (Object)"k");
        System.out.println("val = " + val);
        assert (val == null) : "Older data should not have committed";
        val = this.cache2.get(this.node, (Object)"k");
        System.out.println("val = " + val);
        assert (val.equals("v-newer"));
        NodeSPI n = ((CacheSPI)this.cache1).peek(this.node, true, true);
        assert (((DefaultDataVersion)n.getVersion()).getRawVersion() == 1L) : "Version should be 1";
    }
}

