/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.IOException;
import java.util.Properties;
import net.noderunner.amazon.s3.emulator.Server;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=true)
public class S3CacheLoaderTest
extends CacheLoaderTestsBase {
    private static final Log log = LogFactory.getLog(S3CacheLoaderTest.class);
    private ThreadLocal<Server> serverTL = new ThreadLocal();

    protected void configureCache() throws Exception {
        String properties;
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        String accessKey = System.getProperty("accessKey");
        if (accessKey == null) {
            log.info((Object)"Testing using S3CacheLoader using emulator");
            Server server = new Server();
            this.serverTL.set(server);
            server.start();
            properties = "cache.s3.accessKeyId=dummy\ncache.s3.secretAccessKey=dummy\ncache.s3.server=localhost\ncache.s3.port=" + server.getPort() + "\n" + "cache.s3.callingFormat=VANITY" + "\n" + "cache.s3.bucket=localhost" + "\n";
        } else {
            properties = "cache.s3.accessKeyId=" + accessKey + "\n" + "cache.s3.secretAccessKey=" + System.getProperty("secretKey") + "\n";
        }
        CacheLoaderConfig config = this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.s3.S3CacheLoader", properties, false, true, false);
        Properties p = config.getFirstCacheLoaderConfig().getProperties();
        AssertJUnit.assertNotNull((Object)p.get("cache.s3.accessKeyId"));
        AssertJUnit.assertNotNull((Object)p.get("cache.s3.secretAccessKey"));
        cache.getConfiguration().setCacheLoaderConfig(config);
    }

    public void cleanup() {
        Server server = this.serverTL.get();
        if (server != null) {
            try {
                server.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.serverTL.set(null);
    }

    protected void postConfigure() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.removeNode(Fqn.root());
    }

    public void testCacheLoaderThreadSafety() {
    }

    public void testPartialLoadAndStore() {
    }

    public void testBuddyBackupStore() {
    }

    protected void threadSafetyTest(boolean singleFqn) throws Exception {
    }
}

