/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.factories.context.ContextFactory;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.transaction.DummyBaseTransactionManager;
import org.jboss.cache.transaction.DummyTransaction;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class AbstractLockManagerRecordingTest {
    protected ThreadLocal<AbstractLockManagerRecordingTestTL> threadLocal = new ThreadLocal();
    protected boolean fqnBasedLocking = true;

    @AfterMethod
    public void tearDown() {
        AbstractLockManagerRecordingTestTL tl = this.threadLocal.get();
        if (tl != null) {
            tl.lm = null;
            this.threadLocal.set(null);
        }
    }

    public void testRecordingLocksNoTx() throws InterruptedException {
        AbstractLockManagerRecordingTestTL tl = this.threadLocal.get();
        LockManager lm = tl.lm;
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        NodeSPI node = this.createNode(fqn);
        InvocationContext ctx = (InvocationContext)tl.icc.get();
        lm.lockAndRecord(node, LockType.WRITE, ctx);
        assert (ctx.getLocks().contains(this.fqnBasedLocking ? fqn : node.getLock()));
        assert (ctx.getLocks().size() == 1);
        assert (lm.isLocked(node)) : "Should be locked";
        lm.unlock(ctx);
        assert (!lm.isLocked(node)) : "Should not be locked";
    }

    public void testRecordingLocksWithTx() throws InterruptedException, SystemException, RollbackException {
        AbstractLockManagerRecordingTestTL tl = this.threadLocal.get();
        LockManager lm = tl.lm;
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        NodeSPI node = this.createNode(fqn);
        InvocationContext ctx = (InvocationContext)tl.icc.get();
        ctx.setGlobalTransaction(new GlobalTransaction());
        ctx.setTransaction((Transaction)new DummyTransaction((DummyBaseTransactionManager)DummyTransactionManager.getInstance()));
        ctx.setTransactionContext(tl.contextFactory.createTransactionContext(ctx.getTransaction()));
        lm.lockAndRecord(node, LockType.WRITE, ctx);
        assert (ctx.getLocks().contains(this.fqnBasedLocking ? fqn : node.getLock()));
        assert (ctx.getTransactionContext().getLocks().size() == 1);
        assert (lm.isLocked(node)) : "Should be locked";
        lm.unlock(ctx);
        assert (!lm.isLocked(node)) : "Should not be locked";
    }

    protected NodeSPI createNode(Fqn fqn) {
        UnversionedNode un = new UnversionedNode(fqn);
        return new NodeInvocationDelegate((InternalNode)un);
    }

    protected class AbstractLockManagerRecordingTestTL {
        public LockManager lm;
        public InvocationContextContainer icc;
        protected ContextFactory contextFactory;

        protected AbstractLockManagerRecordingTestTL() {
        }
    }
}

