/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mgmt;

import java.util.HashMap;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=true)
public class InvalidationTest {
    private static final String CLUSTER_NAME = "InvalidationTestCluster";
    private static final String CAPITAL = "capital";
    private static final String CURRENCY = "currency";
    private static final String POPULATION = "population";
    private static final String AREA = "area";
    private CacheSPI<Object, Object> cache1 = null;
    private CacheSPI<Object, Object> cache2 = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = this.createCache(CLUSTER_NAME);
        this.cache2 = this.createCache(CLUSTER_NAME);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache1 != null) {
            TestingUtil.killCaches(new Cache[]{this.cache1});
            this.cache1 = null;
        }
        if (this.cache2 != null) {
            TestingUtil.killCaches(new Cache[]{this.cache2});
            this.cache2 = null;
        }
    }

    public void testInvalidationMgmt() throws Exception {
        AssertJUnit.assertNotNull((String)"Cache1 is null.", this.cache1);
        AssertJUnit.assertNotNull((String)"Cache2 is null.", this.cache2);
        this.loadCache1(this.cache1);
        Fqn key = Fqn.fromString((String)"Europe/Austria");
        AssertJUnit.assertNotNull((String)("Cache1 retrieval error: expected to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNull((String)("Cache2 retrieval error: did not expect to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        key = Fqn.fromString((String)"Europe/Albania");
        AssertJUnit.assertNotNull((String)("Cache1 retrieval error: expected to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNull((String)("Cache2 retrieval error: did not expect to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        this.loadCache2(this.cache2);
        key = Fqn.fromString((String)"Europe/Austria");
        AssertJUnit.assertNull((String)("Cache1 retrieval error: did not expect to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        AssertJUnit.assertNotNull((String)("Cache2 retrieval error: expected to retrieve capital for " + key), (Object)this.cache2.get(key, (Object)CAPITAL));
        key = Fqn.fromString((String)"Europe/Albania");
        AssertJUnit.assertNotNull((String)("Cache1 retrieval error after unrelated eviction: expected to retrieve capital for " + key), (Object)this.cache1.get(key, (Object)CAPITAL));
        InvalidationInterceptor mgmt1 = TestingUtil.findInterceptor(this.cache1, InvalidationInterceptor.class);
        AssertJUnit.assertNotNull((String)"Cache1 InvalidationInterceptor not found.", (Object)mgmt1);
        InvalidationInterceptor mgmt2 = TestingUtil.findInterceptor(this.cache2, InvalidationInterceptor.class);
        AssertJUnit.assertNotNull((String)"Cache2 InvalidationInterceptor not found.", (Object)mgmt2);
        AssertJUnit.assertTrue((String)"Cache1 not configured to use MBeans", (boolean)this.cache1.getConfiguration().getExposeManagementStatistics());
        AssertJUnit.assertTrue((String)"Cache2 not configured to use MBeans", (boolean)this.cache2.getConfiguration().getExposeManagementStatistics());
        AssertJUnit.assertTrue((String)"InvalidationInterceptor on Cache1 not set up to use statistics!", (boolean)mgmt1.getStatisticsEnabled());
        AssertJUnit.assertTrue((String)"InvalidationInterceptor on Cache2 not set up to use statistics!", (boolean)mgmt2.getStatisticsEnabled());
        AssertJUnit.assertEquals((String)"Cache1 Invalidations count error: ", (Object)new Long(6L), (Object)new Long(mgmt1.getInvalidations()));
        AssertJUnit.assertEquals((String)"Cache2 Invalidations count error: ", (Object)new Long(9L), (Object)new Long(mgmt2.getInvalidations()));
        mgmt1.resetStatistics();
        mgmt2.resetStatistics();
        AssertJUnit.assertEquals((String)"Cache1 Invalidations count error after reset: ", (Object)new Long(0L), (Object)new Long(mgmt1.getInvalidations()));
        AssertJUnit.assertEquals((String)"Cache2 Invalidations count error after reset: ", (Object)new Long(0L), (Object)new Long(mgmt2.getInvalidations()));
    }

    private void loadCache1(CacheSPI<Object, Object> cache) {
        cache.put("Europe", new HashMap());
        cache.put("Europe/Austria", new HashMap());
        cache.put("Europe/Austria", (Object)CAPITAL, (Object)"Vienna");
        cache.put("Europe/Austria", (Object)CURRENCY, (Object)"Euro");
        cache.put("Europe/Austria", (Object)POPULATION, (Object)8184691);
        HashMap<String, Object> albania = new HashMap<String, Object>(4);
        albania.put(CAPITAL, "Tirana");
        albania.put(CURRENCY, "Lek");
        albania.put(POPULATION, 3563112);
        albania.put(AREA, 28748);
        cache.put("Europe/Albania", albania);
    }

    private void loadCache2(CacheSPI<Object, Object> cache) {
        cache.put("Europe/Austria", new HashMap());
        cache.put("Europe/Austria", (Object)CAPITAL, (Object)"Vienna");
        cache.put("Europe/Austria", (Object)CURRENCY, (Object)"Euro");
        cache.put("Europe/Austria", (Object)POPULATION, (Object)8184691);
        cache.put("Europe/Romania", new HashMap());
        cache.put("Europe/Romania", (Object)CAPITAL, (Object)"Bucharest");
        cache.put("Europe/Romania", (Object)CURRENCY, (Object)"Leu");
        cache.put("Europe/Romania", (Object)POPULATION, (Object)22329977);
        cache.put("Europe/Romania", (Object)AREA, (Object)237500);
    }

    private CacheSPI<Object, Object> createCache(String clusterName) {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.INVALIDATION_SYNC);
        c.setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
        c.setExposeManagementStatistics(true);
        c.setClusterName(clusterName);
        return (CacheSPI)new UnitTestCacheFactory().createCache(c);
    }
}

