/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.optimistic.TestListener;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true)
public class NodeInterceptorRemoveNodeTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private TestListener listener;
    private MockInterceptor dummy;
    private TransactionManager mgr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.listener = new TestListener();
        this.cache = this.createCacheWithListener(this.listener);
        this.dummy = new MockInterceptor();
        this.cache.addInterceptor((CommandInterceptor)this.dummy, CallInterceptor.class);
        this.cache.removeInterceptor(CallInterceptor.class);
        this.mgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testTransactionRemoveNotExistsNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        this.cache.removeNode("/one/two");
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(CommitCommand.class));
        assert (this.dummy.getAllCalled().contains(OptimisticPrepareCommand.class));
        AssertJUnit.assertEquals((int)0, (int)workspace.getNodes().size());
        AssertJUnit.assertTrue((boolean)entry.getLocks().isEmpty());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)0, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemoveNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        this.cache.removeNode("/one/two");
        assert (this.dummy.getAllCalled().isEmpty());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isRemoved());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isRemoved());
        List mergedChildren = workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren();
        AssertJUnit.assertEquals((int)1, (int)((Set)mergedChildren.get(1)).size());
        System.out.println(entry.getModifications());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
    }

    public void testTransactionRemoveIntermediateNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        this.cache.removeNode("/one");
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isRemoved());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isRemoved());
        AssertJUnit.assertEquals((int)0, (int)((Set)workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren().get(0)).size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(CommitCommand.class));
        assert (this.dummy.getAllCalled().contains(OptimisticPrepareCommand.class));
    }

    public void testTransactionRemoveTwiceMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        workspace.getNode(Fqn.fromString((String)"/one"));
        workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isRemoved());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isRemoved());
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isRemoved());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isRemoved());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(CommitCommand.class));
        assert (this.dummy.getAllCalled().contains(OptimisticPrepareCommand.class));
    }

    public void testTransactionRemovePutNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode two = workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isRemoved());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isRemoved());
        this.cache.put("/one/two", temp);
        WorkspaceNode oneAfter = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode twoAfter = workspace.getNode(Fqn.fromString((String)"/one/two"));
        AssertJUnit.assertSame((Object)one, (Object)oneAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)oneAfter.isRemoved());
        AssertJUnit.assertSame((Object)two, (Object)twoAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)twoAfter.isRemoved());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(CommitCommand.class));
        assert (this.dummy.getAllCalled().contains(OptimisticPrepareCommand.class));
        AssertJUnit.assertEquals((int)2, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemovePutkeyValMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode two = workspace.getNode(Fqn.fromString((String)"/one/two"));
        this.cache.removeNode("/one");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isRemoved());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isRemoved());
        this.cache.put(Fqn.fromString((String)"/one"), (Object)"key1", (Object)"value2");
        WorkspaceNode oneAfter = workspace.getNode(Fqn.fromString((String)"/one"));
        WorkspaceNode twoAfter = workspace.getNode(Fqn.fromString((String)"/one/two"));
        AssertJUnit.assertSame((Object)one, (Object)oneAfter);
        AssertJUnit.assertEquals((boolean)false, (boolean)oneAfter.isRemoved());
        AssertJUnit.assertEquals((Object)two, (Object)twoAfter);
        AssertJUnit.assertEquals((boolean)true, (boolean)twoAfter.isRemoved());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        this.mgr.commit();
        AssertJUnit.assertEquals((Object)"value2", (Object)workspace.getNode(Fqn.fromString((String)"/one")).get((Object)"key1"));
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(CommitCommand.class));
        assert (this.dummy.getAllCalled().contains(OptimisticPrepareCommand.class));
        AssertJUnit.assertEquals((int)2, (int)this.listener.getNodesAdded());
    }

    public void testTransactionRemoveSubNodeMethod() throws Exception {
        this.mgr.begin();
        Transaction tx = this.mgr.getTransaction();
        this.cache.getInvocationContext().setTransaction(tx);
        this.cache.getInvocationContext().setGlobalTransaction(this.cache.getCurrentTransaction(tx, true));
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("key1", "value");
        this.cache.put("/one/two", temp);
        TransactionTable table = this.cache.getTransactionTable();
        GlobalTransaction gtx = table.get(tx);
        OptimisticTransactionContext entry = (OptimisticTransactionContext)table.get(gtx);
        TransactionWorkspace workspace = entry.getTransactionWorkSpace();
        WorkspaceNode one = workspace.getNode(Fqn.fromString((String)"/one"));
        AssertJUnit.assertEquals((int)1, (int)((Set)one.getMergedChildren().get(0)).size());
        this.cache.removeNode("/one/two");
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one/two")));
        AssertJUnit.assertEquals((boolean)true, (boolean)workspace.getNode(Fqn.fromString((String)"/one/two")).isRemoved());
        AssertJUnit.assertNotNull((Object)workspace.getNode(Fqn.fromString((String)"/one")));
        AssertJUnit.assertEquals((boolean)false, (boolean)workspace.getNode(Fqn.fromString((String)"/one")).isRemoved());
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
        this.mgr.commit();
        AssertJUnit.assertEquals((int)1, (int)((Set)workspace.getNode(Fqn.fromString((String)"/one")).getMergedChildren().get(1)).size());
        AssertJUnit.assertEquals((int)3, (int)workspace.getNodes().size());
        AssertJUnit.assertTrue((!this.cache.exists("/one/two") ? 1 : 0) != 0);
        assert (2 == this.dummy.getAllCalled().size());
        assert (this.dummy.getAllCalled().contains(CommitCommand.class));
        assert (this.dummy.getAllCalled().contains(OptimisticPrepareCommand.class));
        AssertJUnit.assertEquals((int)2, (int)this.listener.getNodesAdded());
    }
}

