/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.MockInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true)
public class NodeInterceptorTransactionTest
extends AbstractOptimisticTestCase {
    CacheSPI cache;
    MockInterceptor dummy;

    @BeforeMethod
    public void setUp() throws Exception {
        this.cache = this.createCache();
        OptimisticCreateIfNotExistsInterceptor interceptor = new OptimisticCreateIfNotExistsInterceptor();
        OptimisticNodeInterceptor nodeInterceptor = new OptimisticNodeInterceptor();
        this.dummy = new MockInterceptor();
        interceptor.setNext((CommandInterceptor)nodeInterceptor);
        nodeInterceptor.setNext((CommandInterceptor)this.dummy);
        TestingUtil.replaceInterceptorChain(this.cache, (CommandInterceptor)interceptor);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testNoTransactionCRUDMethod() throws Exception {
        try {
            this.cache.put("/one/two", (Object)"key1", new Object());
            AssertJUnit.fail();
        }
        catch (Throwable t) {
            AssertJUnit.assertTrue((boolean)true);
        }
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
    }

    public void testNoTransactionGetMethod() throws Exception {
        boolean fail = false;
        try {
            AssertJUnit.assertEquals(null, (Object)this.cache.get("/one/two", (Object)"key1"));
        }
        catch (Exception e) {
            fail = true;
        }
        AssertJUnit.assertTrue((boolean)fail);
        AssertJUnit.assertEquals(null, (Object)this.dummy.getCalledCommand());
    }
}

