/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true)
public class VersioningOnReadTest
extends AbstractOptimisticTestCase {
    CacheSPI cache;
    Fqn fqn = Fqn.fromString((String)"/a");
    TransactionManager tm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = this.createCache();
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.destroyCache((Cache<Object, Object>)this.cache);
        this.cache = null;
    }

    public void testUpdateOnWrite() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(this.fqn, (Object)"k"));
        this.tm.begin();
        this.cache.put(this.fqn, (Object)"k", (Object)"v2");
        Transaction tx = this.tm.suspend();
        this.cache.put(this.fqn, (Object)"k", (Object)"v3");
        this.tm.resume(tx);
        try {
            this.tm.commit();
            AssertJUnit.fail((String)"Should have failed with a data version mismatch");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUpdateOnRemove() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(this.fqn, (Object)"k"));
        this.tm.begin();
        this.cache.remove(this.fqn, (Object)"k");
        Transaction tx = this.tm.suspend();
        this.cache.put(this.fqn, (Object)"k", (Object)"v3");
        this.tm.resume(tx);
        try {
            this.tm.commit();
            AssertJUnit.fail((String)"Should have failed with a data version mismatch");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUpdateOnRemoveNode() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(this.fqn, (Object)"k"));
        this.tm.begin();
        this.cache.removeNode(this.fqn);
        Transaction tx = this.tm.suspend();
        this.cache.put(this.fqn, (Object)"k", (Object)"v3");
        this.tm.resume(tx);
        try {
            this.tm.commit();
            AssertJUnit.fail((String)"Should have failed with a data version mismatch");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testUpdateOnRead() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache.get(this.fqn, (Object)"k"));
        this.tm.begin();
        this.cache.get(this.fqn, (Object)"k");
        Transaction tx = this.tm.suspend();
        this.cache.put(this.fqn, (Object)"k", (Object)"v3");
        this.tm.resume(tx);
        this.cache.put(Fqn.fromString((String)"/b"), (Object)"k", (Object)"v");
        this.tm.commit();
    }
}

