/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.passivation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ReplicatedPassivationIntegrationTest {
    private CacheSPI<String, String> cache1;
    private CacheSPI<String, String> cache2;
    protected static final Log log = LogFactory.getLog(ReplicatedPassivationIntegrationTest.class);
    long wakeupIntervalMillis = 0L;
    PassivationListener listener;
    Fqn base = Fqn.fromString((String)"/org/jboss/test/data");

    public ReplicatedPassivationIntegrationTest() {
        this.listener = new PassivationListener();
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache1 = (CacheSPI)instance.createCache(this.getCfg(), false);
        this.cache1.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache1.start();
        this.cache2 = (CacheSPI)instance.createCache(this.getCfg(), false);
        this.cache2.getConfiguration().setUseRegionBasedMarshalling(true);
        this.cache2.start();
        this.cache2.getNotifier().addCacheListener((Object)this.listener);
        this.listener.resetCounter();
        this.wakeupIntervalMillis = this.cache2.getConfiguration().getEvictionConfig().getWakeupInterval();
        this.log("wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis <= 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
    }

    Configuration getCfg() throws Exception {
        Configuration cfg = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        cfg.setEvictionConfig(this.buildEvictionConfig());
        cfg.setCacheLoaderConfig(this.buildCacheLoaderConfig());
        cfg.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        cfg.getCacheLoaderConfig().getFirstCacheLoaderConfig().setClassName(DummyInMemoryCacheLoader.class.getName());
        return cfg;
    }

    private CacheLoaderConfig buildCacheLoaderConfig() throws Exception {
        CacheLoaderConfig clc = new CacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        iclc.setClassName(DummySharedInMemoryCacheLoader.class.getName());
        clc.addIndividualCacheLoaderConfig(iclc);
        clc.setPassivation(true);
        return clc;
    }

    private EvictionConfig buildEvictionConfig() throws Exception {
        EvictionConfig cfg = new EvictionConfig();
        cfg.setWakeupInterval(1000L);
        cfg.setDefaultEventQueueSize(200000);
        EvictionRegionConfig region1 = new EvictionRegionConfig();
        region1.setRegionFqn(Fqn.ROOT);
        LRUAlgorithmConfig epc1 = new LRUAlgorithmConfig();
        epc1.setMaxNodes(5000);
        epc1.setTimeToLive(3000L);
        region1.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)epc1);
        cfg.setDefaultEvictionRegionConfig(region1);
        EvictionRegionConfig region2 = new EvictionRegionConfig();
        region2.setRegionFqn(this.base);
        LRUAlgorithmConfig epc2 = new LRUAlgorithmConfig();
        epc2.setMaxNodes(100);
        epc2.setTimeToLive(3000L);
        region2.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)epc2);
        cfg.addEvictionRegionConfig(region2);
        return cfg;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testActivationEvent() throws Exception {
        Fqn internalFqn = Fqn.fromString((String)"/__JBossInternal__/5c4o12-pzhlhj-esnuy3sg-1-esnuy3sg-2");
        Fqn fqn = Fqn.fromRelativeElements((Fqn)this.base, (Object[])new String[]{"0"});
        this.cache1.removeNode(Fqn.ROOT);
        this.cache1.put(fqn, (Object)fqn.toString(), (Object)fqn.toString());
        this.cache1.put(internalFqn, (Object)fqn.toString(), (Object)fqn.toString());
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 100L);
        NodeSPI n = this.cache2.peek(fqn, false);
        assert (n == null || !n.getKeys().contains(fqn)) : "UnversionedNode should not exist";
        String val = (String)this.cache2.get(fqn, (Object)fqn.toString());
        val = (String)this.cache2.get(internalFqn, (Object)fqn.toString());
        AssertJUnit.assertNotNull((String)"Node should be activated ", (Object)val);
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }

    @CacheListener
    public class PassivationListener {
        int counter = 0;
        int loadedCounter = 0;

        public int getCounter() {
            return this.counter;
        }

        public void resetCounter() {
            this.counter = 0;
            this.loadedCounter = 0;
        }

        @NodeActivated
        public void nodeActivated(NodeEvent ne) {
            if (!ne.isPre()) {
                ++this.counter;
                System.out.println("nodeActivate(): counter: " + this.counter);
                System.out.println("nodeActivate(): " + ne.getFqn());
            }
        }

        @NodePassivated
        public void nodePassivated(NodeEvent ne) {
            if (ne.isPre()) {
                System.out.println("nodePassivate(): " + ne.getFqn());
            }
        }

        @NodeLoaded
        public void nodeLoaded(NodeEvent ne) {
            if (!ne.isPre()) {
                ++this.loadedCounter;
            }
        }
    }
}

