/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public class AsyncReplTest {
    private ThreadLocal<AsyncReplTestTL> threadLocal = new ThreadLocal();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        AsyncReplTestTL tl = new AsyncReplTestTL();
        this.threadLocal.set(tl);
        this.log("creating cache1");
        tl.cache1 = this.createCache("CacheGroup");
        tl.replListener1 = new ReplicationListener((Cache)tl.cache1);
        this.log("creating cache2");
        tl.cache2 = this.createCache("CacheGroup");
        tl.replListener2 = new ReplicationListener((Cache)tl.cache2);
    }

    private CacheSPI<Object, Object> createCache(String name) throws Exception {
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC);
        c.setClusterName(name);
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        this.configureMultiplexer((Cache)cache);
        cache.create();
        cache.start();
        this.validateMultiplexer((Cache)cache);
        return cache;
    }

    protected void configureMultiplexer(Cache cache) throws Exception {
    }

    protected void validateMultiplexer(Cache cache) {
        AssertJUnit.assertFalse((String)"Cache is not using multiplexer", (boolean)cache.getConfiguration().isUsingMultiplexer());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        AsyncReplTestTL tl = this.threadLocal.get();
        TestingUtil.killCaches(new Cache[]{tl.cache1, tl.cache2});
        this.threadLocal.set(null);
    }

    public void testTxCompletion() throws Exception {
        AsyncReplTestTL tl = this.threadLocal.get();
        CacheSPI cache1 = tl.cache1;
        CacheSPI cache2 = tl.cache2;
        ReplicationListener replListener1 = tl.replListener1;
        ReplicationListener replListener2 = tl.replListener2;
        Fqn fqn = Fqn.fromString((String)"/a");
        String key = "key";
        replListener2.expectAny();
        cache1.put(fqn, (Object)key, (Object)"value1");
        replListener2.waitForReplicationToOccur(500L);
        AssertJUnit.assertEquals((Object)"value1", (Object)cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value1", (Object)cache2.get(fqn, (Object)key));
        TransactionManager mgr = cache1.getTransactionManager();
        mgr.begin();
        replListener2.expectAny();
        cache1.put(fqn, (Object)key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value1", (Object)cache2.get(fqn, (Object)key));
        mgr.commit();
        replListener2.waitForReplicationToOccur(500L);
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get(fqn, (Object)key));
        mgr.begin();
        cache1.put(fqn, (Object)key, (Object)"value3");
        AssertJUnit.assertEquals((Object)"value3", (Object)cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get(fqn, (Object)key));
        mgr.rollback();
        AssertJUnit.assertEquals((Object)"value2", (Object)cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)cache2.get(fqn, (Object)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPutShouldNotReplicateToDifferentCluster() {
        CacheSPI<Object, Object> cache4;
        block7: {
            AsyncReplTestTL tl = this.threadLocal.get();
            CacheSPI cache1 = tl.cache1;
            CacheSPI cache2 = tl.cache2;
            ReplicationListener replListener1 = tl.replListener1;
            ReplicationListener replListener2 = tl.replListener2;
            CacheSPI<Object, Object> cache3 = null;
            cache4 = null;
            try {
                try {
                    cache3 = this.createCache("DifferentGroup");
                    cache4 = this.createCache("DifferentGroup");
                    replListener2.expectAny();
                    cache1.put("/a/b/c", (Object)"age", (Object)38);
                    replListener2.waitForReplicationToOccur(500L);
                    AssertJUnit.assertNull((String)"Should not have replicated", (Object)cache3.get("/a/b/c", (Object)"age"));
                }
                catch (Exception e) {
                    AssertJUnit.fail((String)e.toString());
                    Object var10_9 = null;
                    if (cache3 != null) {
                        cache3.stop();
                    }
                    if (cache4 == null) return;
                    cache4.stop();
                    return;
                }
                Object var10_8 = null;
                if (cache3 == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (cache3 != null) {
                    cache3.stop();
                }
                if (cache4 == null) throw throwable;
                cache4.stop();
                throw throwable;
            }
            cache3.stop();
        }
        if (cache4 == null) return;
        cache4.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testStateTransfer() {
        AsyncReplTestTL tl = this.threadLocal.get();
        CacheSPI cache1 = tl.cache1;
        CacheSPI cache2 = tl.cache2;
        ReplicationListener replListener1 = tl.replListener1;
        ReplicationListener replListener2 = tl.replListener2;
        CacheSPI<Object, Object> cache4 = null;
        try {
            try {
                cache1.put("a/b/c", (Object)"age", (Object)38);
                cache4 = this.createCache("CacheGroup");
                System.out.println("" + cache4.getMembers());
                AssertJUnit.assertEquals((int)3, (int)cache4.getMembers().size());
                AssertJUnit.assertEquals((String)"\"age\" should be 38", (Object)38, (Object)cache4.get("/a/b/c", (Object)"age"));
            }
            catch (Exception e) {
                AssertJUnit.fail((String)e.toString());
                Object var9_8 = null;
                if (cache4 == null) return;
                System.out.println("cache4's view: " + cache4.getMembers());
                cache4.stop();
                return;
            }
            Object var9_7 = null;
            if (cache4 == null) return;
            System.out.println("cache4's view: " + cache4.getMembers());
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (cache4 == null) throw throwable;
            System.out.println("cache4's view: " + cache4.getMembers());
            cache4.stop();
            throw throwable;
        }
        cache4.stop();
    }

    public void testAsyncReplDelay() {
        AsyncReplTestTL tl = this.threadLocal.get();
        CacheSPI cache1 = tl.cache1;
        CacheSPI cache2 = tl.cache2;
        ReplicationListener replListener1 = tl.replListener1;
        ReplicationListener replListener2 = tl.replListener2;
        try {
            cache1.put("/a/b/c", (Object)"age", (Object)38);
            Integer age = (Integer)cache2.get("/a/b/c", (Object)"age");
            this.log("attr \"age\" of \"/a/b/c\" on cache2=" + age);
            AssertJUnit.assertTrue((String)"should be either null or 38", (age == null || age == 38 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testAsyncReplTxDelay() {
        AsyncReplTestTL tl = this.threadLocal.get();
        CacheSPI cache1 = tl.cache1;
        CacheSPI cache2 = tl.cache2;
        ReplicationListener replListener1 = tl.replListener1;
        ReplicationListener replListener2 = tl.replListener2;
        try {
            TransactionManager tm = cache1.getTransactionManager();
            tm.begin();
            cache1.put("/a/b/c", (Object)"age", (Object)38);
            tm.commit();
            Integer age = (Integer)cache2.get("/a/b/c", (Object)"age");
            this.log("attr \"age\" of \"/a/b/c\" on cache2=" + age);
            AssertJUnit.assertTrue((String)"should be either null or 38", (age == null || age == 38 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    private void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }

    private class AsyncReplTestTL {
        private CacheSPI<Object, Object> cache1;
        private CacheSPI<Object, Object> cache2;
        private ReplicationListener replListener1;
        private ReplicationListener replListener2;

        private AsyncReplTestTL() {
        }
    }
}

