/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, sequential=true)
public class IsolationLevelReadCommittedNodeCreationRollbackTest {
    private CacheSPI<String, String> cache = null;
    private final String KEY = "key";
    private final String VALUE = "value";
    private volatile boolean writerFailed;
    private volatile boolean readerFailed;
    private volatile AssertionError writerError;
    private volatile AssertionError readerError;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.writerFailed = false;
        this.readerFailed = false;
        this.writerError = null;
        this.readerError = null;
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setIsolationLevel(IsolationLevel.READ_COMMITTED);
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache = (CacheSPI)instance.createCache(c, false);
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testNodeCreationRollback() throws Exception {
        final CountDownLatch secondCanWrite = new CountDownLatch(1);
        final CountDownLatch secondCanRead = new CountDownLatch(1);
        final CountDownLatch secondDone = new CountDownLatch(1);
        final CountDownLatch firstCanRollback = new CountDownLatch(1);
        final CountDownLatch firstDone = new CountDownLatch(1);
        final Fqn PARENT = Fqn.fromString((String)"/a");
        Thread firstThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TransactionManager tm = IsolationLevelReadCommittedNodeCreationRollbackTest.this.startTransaction();
                    System.out.println("Writing /a/1");
                    Fqn a1 = Fqn.fromRelativeElements((Fqn)PARENT, (Object[])new String[]{"1"});
                    IsolationLevelReadCommittedNodeCreationRollbackTest.this.cache.put(a1, (Object)"key", (Object)"value");
                    secondCanWrite.countDown();
                    firstCanRollback.await(3000L, TimeUnit.MILLISECONDS);
                    System.out.println("rolling back");
                    tm.rollback();
                    AssertJUnit.assertNull((String)"a1 empty", (Object)IsolationLevelReadCommittedNodeCreationRollbackTest.this.cache.get(a1, (Object)"key"));
                    secondCanRead.countDown();
                }
                catch (AssertionError e) {
                    IsolationLevelReadCommittedNodeCreationRollbackTest.this.writerError = e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    IsolationLevelReadCommittedNodeCreationRollbackTest.this.writerFailed = true;
                }
                finally {
                    System.out.println("first thread exits");
                    secondCanWrite.countDown();
                    secondCanRead.countDown();
                    firstDone.countDown();
                }
            }
        }, "FIRST");
        firstThread.start();
        Thread secondThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    secondCanWrite.await();
                    System.out.println("writing a2");
                    Fqn a2 = Fqn.fromRelativeElements((Fqn)PARENT, (Object[])new String[]{"2"});
                    try {
                        IsolationLevelReadCommittedNodeCreationRollbackTest.this.cache.put(a2, (Object)"key", (Object)"value");
                    }
                    catch (TimeoutException good) {
                        System.out.println("Prevented from writing a2 -- " + good.getLocalizedMessage());
                        System.out.println("second thread exits");
                        firstCanRollback.countDown();
                        secondDone.countDown();
                        return;
                    }
                    firstCanRollback.countDown();
                    secondCanRead.await();
                    AssertJUnit.assertEquals((String)"write lock not acquired on creation of an empty node", (String)"value", (String)((String)IsolationLevelReadCommittedNodeCreationRollbackTest.this.cache.get(a2, (Object)"key")));
                }
                catch (AssertionError e) {
                    IsolationLevelReadCommittedNodeCreationRollbackTest.this.readerError = e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    IsolationLevelReadCommittedNodeCreationRollbackTest.this.readerFailed = true;
                }
                finally {
                    System.out.println("second thread exits");
                    firstCanRollback.countDown();
                    secondDone.countDown();
                }
            }
        }, "SECOND");
        secondThread.start();
        secondDone.await();
        firstDone.await();
        if (this.readerError != null) {
            throw this.readerError;
        }
        if (this.writerError != null) {
            throw this.writerError;
        }
        if (this.readerFailed) {
            AssertJUnit.fail((String)"The second thread exited incorrectly. Watch the log for previous stack traces");
        }
        if (this.writerFailed) {
            AssertJUnit.fail((String)"The first thread exited incorrectly. Watch the log for previous stack traces");
        }
    }

    private TransactionManager startTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        return mgr;
    }
}

