/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction.pessimistic;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, sequential=true)
public class PrepareTxTest {
    CacheSPI<String, String> cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(false);
        this.cache.getConfiguration().setCacheMode("local");
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache.create();
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testCacheModificationInBeforeCompletionPhase() throws Exception {
        int numLocks = 0;
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        numLocks = this.cache.getNumberOfLocksHeld();
        AssertJUnit.assertEquals((int)4, (int)numLocks);
        tx.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
                try {
                    PrepareTxTest.this.cache.put("/a/b/c", null);
                }
                catch (CacheException e) {
                    e.printStackTrace();
                }
            }

            public void afterCompletion(int status) {
            }
        });
        mgr.commit();
        numLocks = this.cache.getNumberOfLocksHeld();
        AssertJUnit.assertEquals((int)0, (int)numLocks);
        TransactionTable tx_table = this.cache.getTransactionTable();
        int num_local_txs = tx_table.getNumLocalTransactions();
        int num_global_txs = tx_table.getNumGlobalTransactions();
        System.out.println("Number of Transactions: " + num_local_txs + "\nNumber of GlobalTransactions: " + num_global_txs + "\nTransactionTable:\n " + tx_table.toString(true));
        AssertJUnit.assertEquals((int)num_local_txs, (int)num_global_txs);
        AssertJUnit.assertEquals((int)0, (int)num_local_txs);
    }

    public void testCacheModificationInAfterCompletionPhase() throws Exception {
        int numLocks = 0;
        TransactionManager mgr = this.cache.getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        numLocks = this.cache.getNumberOfLocksHeld();
        AssertJUnit.assertEquals((int)4, (int)numLocks);
        tx.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                try {
                    PrepareTxTest.this.cache.put("/a/b/c", null);
                }
                catch (CacheException e) {
                    e.printStackTrace();
                }
            }
        });
        mgr.commit();
        numLocks = this.cache.getNumberOfLocksHeld();
        AssertJUnit.assertEquals((int)0, (int)numLocks);
        TransactionTable tx_table = this.cache.getTransactionTable();
        int num_local_txs = tx_table.getNumLocalTransactions();
        int num_global_txs = tx_table.getNumGlobalTransactions();
        System.out.println("Number of Transactions: " + num_local_txs + "\nNumber of GlobalTransactions: " + num_global_txs + "\nTransactionTable:\n " + tx_table.toString(true));
        AssertJUnit.assertEquals((int)num_local_txs, (int)num_global_txs);
        AssertJUnit.assertEquals((int)0, (int)num_local_txs);
    }
}

