package org.jboss.cache.pojo.test.propagation;

import java.util.List;

/**
 * Main interface for network sensor supervising example.
 */
// We are using JDK1.5 annotation.
@org.jboss.cache.pojo.annotation.Replicable
public interface Node
{
   public void setNodeRDN(String rdn);

   public String getNodeRDN();

   public void setNodeFDN(String fdn);

   public String getNodeFDN();

   public void addChildNode(Node child);

   public List<Node> getChildren();

   public void setParentNode(Node parent);

   public Node getParentNode();

   public void addStateItem(StateItem stateItem);

   public void setSummaryStateItem(StateItem stateItem);

   public StateItem getSummaryStateItem();

   public List<StateItem> getStateItems();

   public StateItem findStateItem(long itemId);

   public void setPropagationRule(PropagationRule rule);

   public PropagationRule getPropagationRule();
}
