/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jgroups.Address;

public class BuddyFqnTransformer {
    public static final String BUDDY_BACKUP_SUBTREE = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_SUBTREE_FQN = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN;

    public Fqn getBackupFqn(Address dataOwnerAddress, Fqn origFqn) {
        return this.getBackupFqn(this.getGroupNameFromAddress(dataOwnerAddress), origFqn);
    }

    public Fqn getBackupFqn(String buddyGroupName, Fqn origFqn) {
        if (BuddyFqnTransformer.isBackupFqn(origFqn)) {
            throw new CacheException("Cannot make a backup Fqn from a backup Fqn! Attempting to create a backup of " + origFqn);
        }
        ArrayList<String> elements = new ArrayList<String>(origFqn.size() + 2);
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add(buddyGroupName);
        elements.addAll(origFqn.peekElements());
        return Fqn.fromList(elements, true);
    }

    public Fqn getBackupFqn(Fqn buddyGroupRoot, Fqn origFqn) {
        if (BuddyFqnTransformer.isBackupFqn(origFqn)) {
            throw new CacheException("Cannot make a backup Fqn from a backup Fqn! Attempting to create a backup of " + origFqn);
        }
        ArrayList<Object> elements = new ArrayList<Object>(origFqn.size() + 2);
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add(buddyGroupRoot.get(1));
        elements.addAll(origFqn.peekElements());
        return Fqn.fromList(elements, true);
    }

    public static boolean isBackupFqn(Fqn name) {
        return name != null && name.hasElement(BUDDY_BACKUP_SUBTREE);
    }

    public Fqn getActualFqn(Fqn fqn) {
        if (!BuddyFqnTransformer.isBackupFqn(fqn)) {
            return fqn;
        }
        if (fqn.equals(BUDDY_BACKUP_SUBTREE_FQN)) {
            return Fqn.ROOT;
        }
        return fqn.getSubFqn(this.isDeadBackupFqn(fqn) ? 3 : 2, fqn.size());
    }

    public boolean isDeadBackupFqn(Fqn name) {
        if (name == null || name.size() < 2) {
            return false;
        }
        Object elem1 = name.get(1);
        if (elem1 instanceof String) {
            String strElem1 = (String)elem1;
            return name.hasElement(BUDDY_BACKUP_SUBTREE) && strElem1.endsWith(":DEAD");
        }
        return false;
    }

    public Fqn getBackupRoot(Address dataOwner) {
        return Fqn.fromRelativeElements(BUDDY_BACKUP_SUBTREE_FQN, this.getGroupNameFromAddress(dataOwner));
    }

    public Fqn getDeadBackupRoot(Address dataOwner) {
        return Fqn.fromRelativeElements(BUDDY_BACKUP_SUBTREE_FQN, this.getGroupNameFromAddress(dataOwner) + ":DEAD");
    }

    public boolean isDeadBackupRoot(Fqn f) {
        return f.isDirectChildOf(BUDDY_BACKUP_SUBTREE_FQN) && f.getLastElementAsString().endsWith(":DEAD");
    }

    public String getGroupNameFromAddress(Address address) {
        return address.toString().replace(':', '_');
    }

    public Fqn getBackupRootFromFqn(Fqn fqn) {
        if (BuddyFqnTransformer.isBackupFqn(fqn) && fqn.size() > 1) {
            return fqn.getSubFqn(0, this.isDeadBackupFqn(fqn) ? 3 : 2);
        }
        return Fqn.root();
    }
}

