/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.JmxStatsCommandInterceptor;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LegacyCacheLoaderInterceptor
extends JmxStatsCommandInterceptor {
    private long cacheLoads = 0L;
    private long cacheMisses = 0L;
    private CacheLoaderManager clm;
    private LockManager lockManager;
    protected TransactionTable txTable = null;
    protected CacheLoader loader;
    protected DataContainer dataContainer;
    protected Notifier notifier;
    protected boolean isActivation = false;
    protected boolean usingVersionedInvalidation = false;
    protected boolean useCacheStore = true;

    @Inject
    protected void injectDependencies(TransactionTable txTable, CacheLoaderManager clm, Configuration configuration, DataContainer dataContainer, LockManager lockManager, Notifier notifier) {
        this.txTable = txTable;
        this.clm = clm;
        Configuration.CacheMode mode = configuration.getCacheMode();
        this.usingVersionedInvalidation = configuration.getNodeLockingScheme().isVersionedScheme() && mode.isInvalidation();
        this.dataContainer = dataContainer;
        this.lockManager = lockManager;
        this.notifier = notifier;
    }

    @Start
    protected void startInterceptor() {
        this.loader = this.clm.getCacheLoader();
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, true, true, false, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), command.getKey(), false, this.useCacheStore, !this.useCacheStore, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        if (command.getFqn() != null) {
            if (command.getTo() != null) {
                this.loadIfNeeded(ctx, command.getTo(), null, false, false, true, ctx.getTransactionContext(), false, true, false);
            }
            this.loadIfNeeded(ctx, command.getFqn(), null, false, false, true, ctx.getTransactionContext(), true, true, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), command.getKey(), false, false, true, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, false, false, true, ctx.getTransactionContext(), false, false, !this.usingVersionedInvalidation);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        Fqn fqn = command.getFqn();
        if (fqn != null) {
            this.loadIfNeeded(ctx, fqn, null, false, false, false, ctx.getTransactionContext(), false, false, true);
            NodeSPI n = this.dataContainer.peek(fqn, true, true);
            this.loadChildren(fqn, n, false, false, ctx);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, true, false, true, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        if (command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, true, false, true, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        List<Fqn> list;
        if (this.trace) {
            this.log.trace((Object)"Removing temporarily created nodes from treecache");
        }
        if ((list = ctx.getTransactionContext().getDummyNodesCreatedByCacheLoader()) != null && list.size() > 0) {
            ListIterator<Fqn> i = list.listIterator(list.size());
            while (i.hasPrevious()) {
                Fqn fqn = i.previous();
                try {
                    this.dataContainer.evict(fqn, false);
                }
                catch (CacheException e) {
                    if (!this.trace) continue;
                    this.log.trace((Object)("Unable to evict node " + fqn), (Throwable)e);
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        if (this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC && command.getFqn() != null) {
            this.loadIfNeeded(ctx, command.getFqn(), null, false, false, false, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        if (command.getFqn() != null && !this.useCacheStore) {
            this.loadIfNeeded(ctx, command.getFqn(), command.getKey(), false, false, false, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Fqn fqn = command.getFqn();
        if (fqn != null && !this.useCacheStore) {
            this.loadIfNeeded(ctx, fqn, null, false, true, false, ctx.getTransactionContext(), false, false, false);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIfNeeded(InvocationContext ctx, Fqn fqn, Object key, boolean allKeys, boolean initNode, boolean acquireLock, TransactionContext transactionContext, boolean recursive, boolean isMove, boolean bypassLoadingData) throws Throwable {
        NodeSPI n = this.dataContainer.peek(fqn, true, true);
        Object lockOwner = this.lockManager.getLockOwner(ctx);
        boolean needLock = n != null && !this.lockManager.ownsLock(fqn, lockOwner);
        boolean mustLoad = false;
        try {
            if (needLock && !this.lockManager.lock(n, LockType.READ, lockOwner)) {
                throw new TimeoutException("Unable to acquire lock on " + fqn + ". Lock info: " + this.lockManager.printLockInfo(n));
            }
            mustLoad = this.mustLoad(n, key, allKeys || isMove);
            Object var16_15 = null;
            if (needLock) {
                this.lockManager.unlock(n, lockOwner);
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (needLock) {
                this.lockManager.unlock(n, lockOwner);
            }
            throw throwable;
        }
        if (this.trace) {
            this.log.trace((Object)("load element " + fqn + " mustLoad=" + mustLoad));
        }
        if (mustLoad) {
            if (initNode) {
                n = this.createTempNode(fqn, transactionContext);
            }
            if (acquireLock) {
                this.lock(fqn, LockType.WRITE, false, ctx);
            }
            if (!this.wasRemovedInTx(fqn, ctx)) {
                if (bypassLoadingData) {
                    if (n == null && this.loader.exists(fqn)) {
                        n = this.createTempNode(fqn, transactionContext);
                    }
                } else {
                    n = this.loadNode(ctx, fqn, n, transactionContext);
                }
            }
        }
        if (recursive) {
            this.loadChildren(fqn, n, recursive, isMove, ctx);
        }
    }

    private void loadChildren(Fqn fqn, NodeSPI node, boolean recursive, boolean isMove, InvocationContext ctxt) throws Throwable {
        Set<?> childrenNames;
        if (node != null && node.isChildrenLoaded()) {
            if (this.trace) {
                this.log.trace((Object)"Children already loaded!");
            }
            return;
        }
        try {
            childrenNames = this.loader.getChildrenNames(fqn);
        }
        catch (Exception e) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Cache loader was unable to load state", (Throwable)e);
            }
            return;
        }
        if (this.trace) {
            this.log.trace((Object)("load children " + fqn + " children=" + childrenNames));
        }
        if (childrenNames == null) {
            if (node != null) {
                if (this.useCacheStore) {
                    node.removeChildrenDirect();
                }
                node.setChildrenLoaded(true);
            }
            return;
        }
        if (node == null) {
            node = this.createNodes(fqn, null);
        }
        for (Object name : childrenNames) {
            Fqn<Object> childFqn = Fqn.fromElements(name);
            NodeSPI<?, ?> child = node.addChildDirect(childFqn);
            if ((isMove || this.isActivation) && recursive) {
                child.setInternalState(this.loader.get(child.getFqn()));
                child.setDataLoaded(true);
            }
            if (!recursive) continue;
            this.loadChildren(child.getFqn(), child, true, isMove, ctxt);
        }
        this.lock(fqn, recursive ? LockType.WRITE : LockType.READ, true, ctxt);
        node.setChildrenLoaded(true);
    }

    private boolean mustLoad(NodeSPI n, Object key, boolean allKeys) {
        if (n == null) {
            if (this.trace) {
                this.log.trace((Object)"must load, node null");
            }
            return true;
        }
        if (!n.isValid() && this.configuration.getNodeLockingScheme().isVersionedScheme()) {
            if (this.trace) {
                this.log.trace((Object)"loading again from cache loader since in-memory node is marked as invalid");
            }
            return true;
        }
        if (!allKeys) {
            if (key == null) {
                if (this.trace) {
                    this.log.trace((Object)"don't load, key requested is null");
                }
                return false;
            }
            if (n.getKeysDirect().contains(key)) {
                if (this.trace) {
                    this.log.trace((Object)"don't load, already have necessary key in memory");
                }
                return false;
            }
        }
        if (!n.isDataLoaded()) {
            if (this.trace) {
                this.log.trace((Object)"must Load, uninitialized");
            }
            return true;
        }
        return false;
    }

    protected void lock(Fqn fqn, LockType lockType, boolean recursive, InvocationContext ctx) throws Throwable {
        if (this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC) {
            return;
        }
        if (recursive) {
            this.lockManager.lockAllAndRecord(fqn, lockType, ctx);
        } else {
            this.lockManager.lockAndRecord(fqn, lockType, ctx);
        }
    }

    private boolean wasRemovedInTx(Fqn fqn, InvocationContext ctx) {
        TransactionContext transactionContext = ctx.getTransactionContext();
        if (transactionContext == null) {
            return false;
        }
        for (WriteCommand txCacheCommand : transactionContext.getModifications()) {
            if (!(txCacheCommand instanceof RemoveNodeCommand) || !fqn.isChildOrEquals(txCacheCommand.getFqn())) continue;
            return true;
        }
        return false;
    }

    private NodeSPI loadNode(InvocationContext ctx, Fqn fqn, NodeSPI n, TransactionContext transactionContext) throws Exception {
        Map nodeData;
        if (this.trace) {
            this.log.trace((Object)("loadNode " + fqn));
        }
        if ((nodeData = this.loadData(fqn)) != null) {
            if (this.trace) {
                this.log.trace((Object)"Node data is not null, loading");
            }
            this.notifier.notifyNodeLoaded(fqn, true, Collections.emptyMap(), ctx);
            if (this.isActivation) {
                this.notifier.notifyNodeActivated(fqn, true, Collections.emptyMap(), ctx);
            }
            n = this.createNodes(fqn, transactionContext);
            n.setInternalState(nodeData);
            if (this.usingVersionedInvalidation) {
                n.setValid(true, false);
            }
            this.notifier.notifyNodeLoaded(fqn, false, nodeData, ctx);
            if (this.isActivation) {
                this.notifier.notifyNodeActivated(fqn, false, nodeData, ctx);
            }
        }
        if (n != null && !n.isDataLoaded()) {
            if (this.trace) {
                this.log.trace((Object)"Setting dataLoaded to true");
            }
            n.setDataLoaded(true);
        }
        return n;
    }

    private NodeSPI createTempNode(Fqn fqn, TransactionContext transactionContext) throws Exception {
        NodeSPI<?, ?> n = this.createNodes(fqn, transactionContext);
        n.setDataLoaded(false);
        if (this.trace) {
            this.log.trace((Object)("createTempNode n " + n));
        }
        return n;
    }

    private NodeSPI<?, ?> createNodes(Fqn fqn, TransactionContext transactionContext) throws Exception {
        Object[] results = this.dataContainer.createNodes(fqn);
        List createdNodes = (List)results[0];
        NodeSPI lastCreated = null;
        for (NodeSPI node : createdNodes) {
            node.setDataLoaded(false);
            if (transactionContext != null) {
                transactionContext.addDummyNodeCreatedByCacheLoader(node.getFqn());
            }
            lastCreated = node;
        }
        if (lastCreated != null) {
            lastCreated.setDataLoaded(true);
        }
        return (NodeSPI)results[1];
    }

    private Map loadData(Fqn fqn) throws Exception {
        boolean nodeExists;
        Map<Object, Object> nodeData = this.loader.get(fqn);
        boolean bl = nodeExists = nodeData != null;
        if (this.trace) {
            this.log.trace((Object)("nodeExists " + nodeExists));
        }
        if (this.getStatisticsEnabled()) {
            if (nodeExists) {
                ++this.cacheLoads;
            } else {
                ++this.cacheMisses;
            }
        }
        return nodeData;
    }

    @ManagedAttribute(description="number of cache loader node loads")
    public long getCacheLoaderLoads() {
        return this.cacheLoads;
    }

    @ManagedAttribute(description="number of cache loader node misses")
    public long getCacheLoaderMisses() {
        return this.cacheMisses;
    }

    @Override
    @ManagedOperation
    public void resetStatistics() {
        this.cacheLoads = 0L;
        this.cacheMisses = 0L;
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("CacheLoaderLoads", this.cacheLoads);
        retval.put("CacheLoaderMisses", this.cacheMisses);
        return retval;
    }
}

