/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.Version;
import org.jboss.cache.batch.BatchContainer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.NonVolatile;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.invocation.AbstractInvocationDelegate;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.mvcc.MVCCNodeHelper;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.Immutables;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonVolatile
public class CacheInvocationDelegate<K, V>
extends AbstractInvocationDelegate
implements CacheSPI<K, V> {
    private static final Log log = LogFactory.getLog(CacheInvocationDelegate.class);
    private StateTransferManager stateTransferManager;
    private CacheLoaderManager cacheLoaderManager;
    private Notifier notifier;
    private TransactionManager transactionManager;
    private BuddyManager buddyManager;
    private TransactionTable transactionTable;
    private RPCManager rpcManager;
    private RegionManager regionManager;
    private Marshaller marshaller;
    private DataContainer dataContainer;
    private CommandsFactory commandsFactory;
    private MVCCNodeHelper mvccHelper;
    private boolean usingMvcc;
    private BatchContainer batchContainer;

    @Inject
    public void initialize(StateTransferManager stateTransferManager, CacheLoaderManager cacheLoaderManager, Notifier notifier, TransactionManager transactionManager, BuddyManager buddyManager, TransactionTable transactionTable, RPCManager rpcManager, RegionManager regionManager, Marshaller marshaller, CommandsFactory commandsFactory, DataContainer dataContainer, MVCCNodeHelper mvccHelper, BatchContainer batchContainer) {
        this.stateTransferManager = stateTransferManager;
        this.cacheLoaderManager = cacheLoaderManager;
        this.notifier = notifier;
        this.transactionManager = transactionManager;
        this.buddyManager = buddyManager;
        this.transactionTable = transactionTable;
        this.rpcManager = rpcManager;
        this.regionManager = regionManager;
        this.marshaller = marshaller;
        this.dataContainer = dataContainer;
        this.commandsFactory = commandsFactory;
        this.mvccHelper = mvccHelper;
        this.batchContainer = batchContainer;
    }

    @Start
    void setNodeLockingScheme() {
        this.usingMvcc = this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.MVCC;
    }

    private void reset() {
        this.usingMvcc = false;
        this.stateTransferManager = null;
        this.cacheLoaderManager = null;
        this.transactionManager = null;
        this.buddyManager = null;
        this.transactionTable = null;
        this.rpcManager = null;
        this.marshaller = null;
        this.dataContainer = null;
        this.commandsFactory = null;
    }

    public String toString() {
        return this.dataContainer == null ? super.toString() : this.dataContainer.toString();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public NodeSPI<K, V> getRoot() {
        return this.getNode(Fqn.ROOT);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public void addInterceptor(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.invoker.addAfterInterceptor(i, afterInterceptor);
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return this.invoker.asList();
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public CacheLoaderManager getCacheLoaderManager() {
        return this.cacheLoaderManager;
    }

    @Override
    public BuddyManager getBuddyManager() {
        return this.buddyManager;
    }

    @Override
    public TransactionTable getTransactionTable() {
        return this.transactionTable;
    }

    @Override
    public RPCManager getRPCManager() {
        return this.rpcManager;
    }

    @Override
    public StateTransferManager getStateTransferManager() {
        return this.stateTransferManager;
    }

    @Override
    public String getClusterName() {
        return this.configuration.getClusterName();
    }

    @Override
    public int getNumberOfAttributes() {
        return this.dataContainer.getNumberOfAttributes();
    }

    @Override
    public int getNumberOfNodes() {
        return this.dataContainer.getNumberOfNodes();
    }

    @Override
    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    @Override
    public GlobalTransaction getCurrentTransaction(Transaction tx, boolean createIfNotExists) {
        return this.transactionTable.getCurrentTransaction(tx, createIfNotExists);
    }

    @Override
    public GlobalTransaction getCurrentTransaction() {
        return this.transactionTable.getCurrentTransaction();
    }

    @Override
    public Set<Fqn> getInternalFqns() {
        return this.dataContainer.getInternalFqns();
    }

    @Override
    public int getNumberOfLocksHeld() {
        return this.dataContainer.getNumberOfLocksHeld();
    }

    @Override
    public boolean exists(String fqn) {
        return this.exists(Fqn.fromString(fqn));
    }

    @Override
    public boolean exists(Fqn fqn) {
        if (this.usingMvcc) {
            InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
            this.cacheStatusCheck(ctx);
            ExistsCommand command = this.commandsFactory.buildExistsNodeCommand(fqn);
            return (Boolean)this.invoker.invoke(ctx, command);
        }
        return this.peek(fqn, false) != null;
    }

    @Override
    public Notifier getNotifier() {
        return this.notifier;
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public GravitateResult gravitateData(Fqn fqn, boolean searchBuddyBackupSubtrees, InvocationContext ctx) {
        this.cacheStatusCheck(ctx);
        GravitateDataCommand command = this.commandsFactory.buildGravitateDataCommand(fqn, searchBuddyBackupSubtrees);
        return (GravitateResult)this.invoker.invoke(ctx, command);
    }

    @Override
    public NodeSPI<K, V> peek(Fqn fqn, boolean includeDeletedNodes, boolean includeInvalidNodes) {
        return this.usingMvcc ? this.mvccPeek(fqn) : this.dataContainer.peek(fqn, includeDeletedNodes, includeInvalidNodes);
    }

    @Override
    public NodeSPI<K, V> peek(Fqn fqn, boolean includeDeletedNodes) {
        return this.usingMvcc ? this.mvccPeek(fqn) : this.dataContainer.peek(fqn, includeDeletedNodes);
    }

    private NodeSPI<K, V> mvccPeek(Fqn f) {
        NodeSPI n;
        try {
            n = this.mvccHelper.wrapNodeForReading(this.getInvocationContext(), f, false);
        }
        catch (InterruptedException e) {
            throw new CacheException(e);
        }
        if (n == null || n.isNullNode()) {
            return null;
        }
        return n;
    }

    @Override
    public void addCacheListener(Object listener) {
        this.notifier.addCacheListener(listener);
    }

    @Override
    public void removeCacheListener(Object listener) {
        this.notifier.removeCacheListener(listener);
    }

    @Override
    public Set<Object> getCacheListeners() {
        return this.notifier.getCacheListeners();
    }

    @Override
    public void create() throws CacheException {
        this.componentRegistry.create();
    }

    @Override
    public void start() throws CacheException {
        this.componentRegistry.start();
    }

    @Override
    public void stop() {
        this.componentRegistry.stop();
    }

    @Override
    public void destroy() {
        this.reset();
        this.componentRegistry.destroy();
    }

    @Override
    public CacheStatus getCacheStatus() {
        return this.componentRegistry.getState();
    }

    @Override
    public InvocationContext getInvocationContext() {
        this.assertIsConstructed();
        return (InvocationContext)this.invocationContextContainer.get();
    }

    @Override
    public void setInvocationContext(InvocationContext ctx) {
        this.assertIsConstructed();
        if (ctx == null) {
            this.invocationContextContainer.remove();
        } else {
            this.invocationContextContainer.set(ctx);
        }
    }

    @Override
    public Address getLocalAddress() {
        if (this.rpcManager == null) {
            return null;
        }
        return this.rpcManager.getLocalAddress();
    }

    @Override
    public List<Address> getMembers() {
        if (this.rpcManager == null) {
            return null;
        }
        return this.rpcManager.getMembers();
    }

    @Override
    public String getVersion() {
        return Version.printVersion();
    }

    @Override
    public void move(Fqn nodeToMove, Fqn newParent) throws NodeNotExistsException {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        MoveCommand command = this.commandsFactory.buildMoveCommand(nodeToMove, newParent);
        this.invoker.invoke(ctx, command);
    }

    @Override
    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.move(Fqn.fromString(nodeToMove), Fqn.fromString(newParent));
    }

    @Override
    public boolean removeRegion(Fqn fqn) {
        return this.regionManager.removeRegion(fqn);
    }

    @Override
    public Region getRegion(Fqn fqn, boolean createIfAbsent) {
        return this.regionManager.getRegion(fqn, createIfAbsent);
    }

    @Override
    public void evict(Fqn fqn, boolean recursive) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        EvictCommand c = this.commandsFactory.buildEvictFqnCommand(fqn);
        c.setRecursive(recursive);
        this.invoker.invoke(ctx, c);
    }

    @Override
    public void evict(Fqn fqn) {
        this.evict(fqn, false);
    }

    @Override
    public V get(Fqn fqn, K key) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(fqn, key, true);
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public V get(String fqn, K key) {
        return this.get(Fqn.fromString(fqn), key);
    }

    @Override
    public boolean removeNode(Fqn fqn) {
        if (fqn.isRoot()) {
            boolean result = true;
            InvocationContext ctx = this.getInvocationContext();
            Option o = ctx.getOptionOverrides();
            Set<Fqn> internalFqns = this.getInternalFqns();
            for (Object childName : this.peek(fqn, false, false).getChildrenNames()) {
                if (internalFqns.contains(Fqn.fromElements(childName))) continue;
                ctx.setOptionOverrides(o);
                result = this.removeNode(Fqn.fromRelativeElements(fqn, childName)) && result;
            }
            return result;
        }
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GlobalTransaction tx = this.transactionTable.getCurrentTransaction();
        RemoveNodeCommand command = this.commandsFactory.buildRemoveNodeCommand(tx, fqn);
        Object retval = this.invoker.invoke(ctx, command);
        return retval != null && (Boolean)retval != false;
    }

    @Override
    public boolean removeNode(String fqn) {
        return this.removeNode(Fqn.fromString(fqn));
    }

    @Override
    public NodeSPI<K, V> getNode(Fqn fqn) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GetNodeCommand command = this.commandsFactory.buildGetNodeCommand(fqn);
        return (NodeSPI)this.invoker.invoke(ctx, command);
    }

    @Override
    public NodeSPI<K, V> getNode(String fqn) {
        return this.getNode(Fqn.fromString(fqn));
    }

    @Override
    public V remove(Fqn fqn, K key) throws CacheException {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GlobalTransaction tx = this.transactionTable.getCurrentTransaction();
        RemoveKeyCommand command = this.commandsFactory.buildRemoveKeyCommand(tx, fqn, key);
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public V remove(String fqn, K key) {
        return this.remove(Fqn.fromString(fqn), key);
    }

    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        PutDataMapCommand command = this.commandsFactory.buildPutDataMapCommand(null, fqn, data);
        this.invoker.invoke(ctx, command);
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data) {
        this.put(Fqn.fromString(fqn), data);
    }

    @Override
    public void putForExternalRead(Fqn fqn, K key, V value) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        if (this.peek(fqn, false, false) == null) {
            this.getInvocationContext().getOptionOverrides().setFailSilently(true);
            this.getInvocationContext().getOptionOverrides().setForceAsynchronous(true);
            PutForExternalReadCommand command = this.commandsFactory.buildPutForExternalReadCommand(null, fqn, key, value);
            this.invoker.invoke(ctx, command);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("putForExternalRead() called with Fqn " + fqn + " and this node already exists.  This method is hence a no op."));
        }
    }

    @Override
    public V put(Fqn fqn, K key, V value) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GlobalTransaction tx = this.transactionTable.getCurrentTransaction();
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(tx, fqn, key, value);
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public V put(String fqn, K key, V value) {
        return this.put(Fqn.fromString(fqn), key, value);
    }

    @Override
    public Map<K, V> getData(Fqn fqn) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GetDataMapCommand command = this.commandsFactory.buildGetDataMapCommand(fqn);
        return (Map)this.invoker.invoke(ctx, command);
    }

    @Override
    public Set<K> getKeys(String fqn) {
        return this.getKeys(Fqn.fromString(fqn));
    }

    @Override
    public Set<K> getKeys(Fqn fqn) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GetKeysCommand command = this.commandsFactory.buildGetKeysCommand(fqn);
        return (Set)this.invoker.invoke(ctx, command);
    }

    @Override
    public void clearData(String fqn) throws CacheException {
        this.clearData(Fqn.fromString(fqn));
    }

    @Override
    public void clearData(Fqn fqn) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GlobalTransaction tx = this.getCurrentTransaction();
        this.invoker.invoke(ctx, this.commandsFactory.buildClearDataCommand(tx, fqn));
    }

    @Override
    public void startBatch() {
        if (!this.configuration.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        this.batchContainer.startBatch();
    }

    @Override
    public void endBatch(boolean successful) {
        if (!this.configuration.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        this.batchContainer.endBatch(successful);
    }

    @Override
    public Set<Object> getChildrenNames(Fqn fqn) {
        InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
        this.cacheStatusCheck(ctx);
        GetChildrenNamesCommand command = this.commandsFactory.buildGetChildrenNamesCommand(fqn);
        Set<Object> retval = (Set<Object>)this.invoker.invoke(ctx, command);
        retval = retval != null ? Immutables.immutableSetWrap(retval) : Collections.emptySet();
        return retval;
    }

    @Override
    public Set<String> getChildrenNames(String fqn) {
        return this.getChildrenNames(Fqn.fromString(fqn));
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    protected void cacheStatusCheck(InvocationContext ctx) {
        this.assertIsConstructed();
        if (!ctx.getOptionOverrides().isSkipCacheStatusCheck() && !this.componentRegistry.invocationsAllowed(true)) {
            throw new IllegalStateException("Cache not in STARTED state!");
        }
    }
}

