/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeNotValidException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Option;
import org.jboss.cache.invocation.AbstractInvocationDelegate;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInvocationDelegate<K, V>
extends AbstractInvocationDelegate
implements NodeSPI<K, V> {
    private static final Log log = LogFactory.getLog(NodeInvocationDelegate.class);
    private static final boolean trace = log.isTraceEnabled();
    protected volatile InternalNode<K, V> node;
    private CacheSPI<K, V> spi;

    public NodeInvocationDelegate(InternalNode<K, V> node) {
        this.node = node;
    }

    @Override
    public InternalNode getDelegationTarget() {
        return this.node;
    }

    public void injectDependencies(CacheSPI<K, V> spi) {
        this.spi = spi;
    }

    @Override
    public boolean isChildrenLoaded() {
        return this.node.isChildrenLoaded();
    }

    @Override
    public void setChildrenLoaded(boolean loaded) {
        this.node.setChildrenLoaded(loaded);
    }

    @Override
    public boolean isDataLoaded() {
        return this.node.isDataLoaded();
    }

    @Override
    public void setDataLoaded(boolean dataLoaded) {
        this.node.setDataLoaded(dataLoaded);
    }

    @Override
    public Map<Object, Node<K, V>> getChildrenMapDirect() {
        return this.node.getChildrenMapDirect();
    }

    @Override
    public void setChildrenMapDirect(Map<Object, Node<K, V>> children) {
        this.node.setChildrenMapDirect(children);
    }

    @Override
    public NodeSPI<K, V> getOrCreateChild(Object name, GlobalTransaction tx) {
        return this.node.getOrCreateChild(name, tx);
    }

    @Override
    public NodeLock getLock() {
        return this.node.getLock();
    }

    @Override
    public void setFqn(Fqn f) {
        this.node.setFqn(f);
    }

    @Override
    public boolean isDeleted() {
        return this.node.isRemoved();
    }

    @Override
    public void markAsDeleted(boolean marker) {
        this.node.setRemoved(marker);
    }

    @Override
    public void markAsDeleted(boolean marker, boolean recursive) {
        this.node.markAsRemoved(marker, recursive);
    }

    @Override
    public void addChild(Object nodeName, Node<K, V> nodeToAdd) {
        this.node.addChildDirect(nodeName, nodeToAdd);
    }

    @Override
    public void printDetails(StringBuilder sb, int indent) {
        this.node.printDetails(sb, indent);
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        throw new CacheException("This method is deprecated!");
    }

    @Override
    public void setVersion(DataVersion version) {
        this.node.setVersion(version);
    }

    @Override
    public DataVersion getVersion() {
        return this.node.getVersion();
    }

    @Override
    public Set<NodeSPI<K, V>> getChildrenDirect() {
        return this.node.getChildrenDirect();
    }

    @Override
    public void removeChildrenDirect() {
        this.node.removeChildren();
    }

    @Override
    public Set<NodeSPI<K, V>> getChildrenDirect(boolean includeMarkedAsDeleted) {
        return this.node.getChildrenDirect(includeMarkedAsDeleted);
    }

    @Override
    public NodeSPI<K, V> getChildDirect(Object childName) {
        return this.node.getChildDirect(childName);
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Fqn childName) {
        return this.node.addChildDirect(childName);
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Fqn f, boolean notify) {
        return this.node.addChildDirect(f, notify);
    }

    @Override
    public NodeSPI<K, V> addChildDirect(Object childName, boolean notify) {
        return this.node.addChildDirect(childName, notify);
    }

    @Override
    public void addChildDirect(NodeSPI<K, V> child) {
        this.node.addChildDirect(child);
    }

    @Override
    public NodeSPI<K, V> getChildDirect(Fqn childName) {
        return this.node.getChildDirect(childName);
    }

    @Override
    public boolean removeChildDirect(Fqn fqn) {
        return this.node.removeChild(fqn);
    }

    @Override
    public boolean removeChildDirect(Object childName) {
        return this.node.removeChild(childName);
    }

    @Override
    public V removeDirect(K key) {
        return this.node.remove(key);
    }

    @Override
    public V putDirect(K key, V value) {
        return this.node.put(key, value);
    }

    @Override
    public void putAllDirect(Map<? extends K, ? extends V> data) {
        this.node.putAll(data);
    }

    @Override
    public Map<K, V> getDataDirect() {
        return this.node.getData();
    }

    @Override
    public V getDirect(K key) {
        return this.node.get(key);
    }

    @Override
    public void clearDataDirect() {
        this.node.clear();
    }

    @Override
    public Set<K> getKeysDirect() {
        return this.node.getKeys();
    }

    @Override
    public Set<Object> getChildrenNamesDirect() {
        return this.node.getChildrenNames();
    }

    @Override
    public CacheSPI<K, V> getCache() {
        return this.spi;
    }

    @Override
    public NodeSPI<K, V> getParent() {
        Fqn f = this.getFqn();
        if (f.isRoot()) {
            return this;
        }
        return this.spi.getNode(f.getParent());
    }

    @Override
    public NodeSPI<K, V> getParentDirect() {
        return this.node.getParent();
    }

    @Override
    public Set<Node<K, V>> getChildren() {
        this.assertValid();
        if (this.spi == null) {
            return Collections.emptySet();
        }
        HashSet<NodeSPI<K, V>> children = new HashSet<NodeSPI<K, V>>();
        for (Object c : this.spi.getChildrenNames(this.getFqn())) {
            NodeSPI<K, V> n = this.spi.getNode(Fqn.fromRelativeElements(this.getFqn(), c));
            if (n == null) continue;
            children.add(n);
        }
        return Collections.unmodifiableSet(children);
    }

    @Override
    public Set<Object> getChildrenNames() {
        this.assertValid();
        return this.spi.getChildrenNames(this.getFqn());
    }

    @Override
    public Map<K, V> getData() {
        this.assertValid();
        if (this.spi == null) {
            return Collections.emptyMap();
        }
        return this.spi.getData(this.getFqn());
    }

    @Override
    public Set<K> getKeys() {
        this.assertValid();
        Set keys = this.spi.getKeys(this.getFqn());
        if (keys == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    public Fqn getFqn() {
        return this.node.getFqn();
    }

    @Override
    public Node<K, V> addChild(Fqn f) {
        this.assertValid();
        Fqn nf = Fqn.fromRelativeFqn(this.getFqn(), f);
        Option o1 = this.spi.getInvocationContext().getOptionOverrides().copy();
        Node<K, V> child = this.getChild(f);
        if (child == null) {
            if (trace) {
                log.trace((Object)"Child is null; creating.");
            }
            Option o2 = o1.copy();
            this.spi.getInvocationContext().setOptionOverrides(o1);
            this.spi.put(nf, null);
            if (trace) {
                log.trace((Object)"Created.  Now getting again.");
            }
            this.spi.getInvocationContext().setOptionOverrides(o2);
            child = this.getChild(f);
            if (trace) {
                log.trace((Object)("Got child " + child));
            }
        }
        return child;
    }

    @Override
    public boolean removeChild(Fqn f) {
        this.assertValid();
        return this.spi.removeNode(Fqn.fromRelativeFqn(this.getFqn(), f));
    }

    @Override
    public boolean removeChild(Object childName) {
        this.assertValid();
        return this.spi.removeNode(Fqn.fromRelativeElements(this.getFqn(), childName));
    }

    @Override
    public Node<K, V> getChild(Fqn f) {
        this.assertValid();
        return this.spi.getNode(Fqn.fromRelativeFqn(this.getFqn(), f));
    }

    @Override
    public Node<K, V> getChild(Object name) {
        this.assertValid();
        return this.spi.getNode(Fqn.fromRelativeElements(this.getFqn(), name));
    }

    @Override
    public V put(K key, V value) {
        this.assertValid();
        return this.spi.put(this.getFqn(), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        this.assertValid();
        NodeInvocationDelegate nodeInvocationDelegate = this;
        synchronized (nodeInvocationDelegate) {
            if (!this.getKeys().contains(k)) {
                return this.put(k, v);
            }
            return this.get(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.assertValid();
        NodeInvocationDelegate nodeInvocationDelegate = this;
        synchronized (nodeInvocationDelegate) {
            if (this.getKeys().contains(key)) {
                return this.put(key, value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.assertValid();
        NodeInvocationDelegate nodeInvocationDelegate = this;
        synchronized (nodeInvocationDelegate) {
            if (oldValue.equals(this.get(key))) {
                this.put(key, newValue);
                return true;
            }
            return false;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> data) {
        this.assertValid();
        this.spi.put(this.getFqn(), data);
    }

    @Override
    public void replaceAll(Map<? extends K, ? extends V> data) {
        this.assertValid();
        this.spi.clearData(this.getFqn());
        this.spi.put(this.getFqn(), data);
    }

    @Override
    public V get(K key) {
        this.assertValid();
        return this.spi.get(this.getFqn(), key);
    }

    @Override
    public V remove(K key) {
        this.assertValid();
        return this.spi.remove(this.getFqn(), key);
    }

    @Override
    public void clearData() {
        this.assertValid();
        this.spi.clearData(this.getFqn());
    }

    @Override
    public int dataSize() {
        this.assertValid();
        return this.spi.getKeys(this.getFqn()).size();
    }

    @Override
    public boolean hasChild(Fqn f) {
        this.assertValid();
        return this.getChild(f) != null;
    }

    @Override
    public boolean hasChild(Object o) {
        this.assertValid();
        return this.getChild(o) != null;
    }

    @Override
    public boolean isValid() {
        return this.node.isValid();
    }

    @Override
    public boolean isResident() {
        return this.node.isResident();
    }

    @Override
    public void setResident(boolean resident) {
        this.node.setResident(resident);
    }

    @Override
    public boolean isLockForChildInsertRemove() {
        return this.node.isLockForChildInsertRemove();
    }

    @Override
    public void setLockForChildInsertRemove(boolean lockForChildInsertRemove) {
        this.node.setLockForChildInsertRemove(lockForChildInsertRemove);
    }

    @Override
    public void releaseObjectReferences(boolean recursive) {
        this.node.releaseObjectReferences(recursive);
    }

    @Override
    public boolean hasChildrenDirect() {
        return this.node.hasChildren();
    }

    @Override
    public Map getInternalState(boolean onlyInternalState) {
        return this.node.getInternalState(onlyInternalState);
    }

    @Override
    public void setInternalState(Map state) {
        this.node.setInternalState(state);
    }

    @Override
    public void setValid(boolean valid, boolean recursive) {
        this.node.setValid(valid, recursive);
    }

    protected void assertValid() {
        if (!this.getFqn().isRoot() && !this.node.isValid()) {
            throw new NodeNotValidException("Node " + this.getFqn() + " is not valid.  Perhaps it has been moved or removed.");
        }
    }

    public String toString() {
        return this.node == null ? "null" : this.node.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInvocationDelegate that = (NodeInvocationDelegate)o;
        return !(this.node != null ? !this.node.equals(that.node) : that.node != null);
    }

    public int hashCode() {
        return this.node != null ? this.node.hashCode() : 0;
    }

    @Override
    public boolean isNullNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markForUpdate(DataContainer container, boolean writeSkewCheck) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void commitUpdate(InvocationContext ctx, DataContainer container) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isChanged() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCreated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCreated(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollbackUpdate() {
        throw new UnsupportedOperationException();
    }
}

