/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.HashMap;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="TreeCacheFunctionalTest")
public class TreeCacheFunctionalTest {
    CacheSPI<Object, Object> cache = null;
    final Fqn FQN = Fqn.fromString((String)"/myNode");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.create();
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
    }

    public void testPut() throws CacheException {
        this.cache.put("/a/b/c", (Object)"age", (Object)38);
        AssertJUnit.assertEquals((Object)this.cache.get("/a/b/c", (Object)"age"), (Object)38);
        AssertJUnit.assertNotNull((Object)this.cache.getNode("/a/b/c"));
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testPutNullKey() throws CacheException {
        Object key = null;
        this.cache.put("/a/b/c", key, (Object)"val");
    }

    public void testPutNullValue() throws CacheException {
        Object val = null;
        this.cache.put("/a/b/c", (Object)"key", val);
    }

    public void testPutNullKeyAndValues() throws CacheException {
        Object key = null;
        Object val = null;
        this.cache.put("/a/b/c", key, val);
    }

    public void testPutMapsWithNullValues() throws CacheException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", null);
        map.put(null, "val");
        map.put("a", "b");
        map.put(null, null);
        this.cache.put("/a/b/c", map);
    }

    public void testPutKeys() throws CacheException {
        this.cache.put("/a/b/c", (Object)"age", (Object)38);
        this.cache.put("/a/b/c", (Object)"name", (Object)"Bela");
        AssertJUnit.assertEquals((Object)this.cache.get("/a/b/c", (Object)"age"), (Object)38);
        AssertJUnit.assertNotNull((Object)this.cache.getNode("/a/b/c"));
        AssertJUnit.assertEquals((int)this.cache.getNode("/a/b/c").getKeys().size(), (int)2);
        AssertJUnit.assertEquals((boolean)this.cache.exists("/a/b/c"), (boolean)true);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }

    public void testRemove() throws CacheException {
        this.cache.put("/a/b/c", null);
        this.cache.put("/a/b/c/1", null);
        this.cache.put("/a/b/c/2", null);
        this.cache.put("/a/b/c/3", null);
        this.cache.put("/a/b/c/3/a/b/c", null);
        this.cache.removeNode("/a/b/c");
        AssertJUnit.assertEquals((int)0, (int)this.cache.getNumberOfLocksHeld());
    }
}

