/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "pessimistic"}, sequential=true, testName="api.ResidentNodesTest")
public class ResidentNodesTest {
    private CacheSPI<Object, Object> cache;
    private EvictionController evController;
    private final String TEST_NODES_ROOT = "residentNodesTest";
    private Cache[] caches = new Cache[0];

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Configuration cacheConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        cacheConfig.setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(cacheConfig, false);
        this.cache.getConfiguration().getEvictionConfig().setWakeupInterval(1000L);
        this.createNewRegion();
        this.cache.start();
        this.evController = new EvictionController((Cache)this.cache);
    }

    private void createNewRegion() {
        EvictionConfig evConfig = this.cache.getConfiguration().getEvictionConfig();
        EvictionRegionConfig evRegConfig = new EvictionRegionConfig();
        evRegConfig.setRegionFqn(Fqn.fromString((String)"/residentNodesTest"));
        evRegConfig.setEventQueueSize(100);
        LRUAlgorithmConfig lruConfig = new LRUAlgorithmConfig();
        lruConfig.setMaxAge(100000000L);
        lruConfig.setTimeToLive(100000000L);
        lruConfig.setMaxNodes(3);
        evRegConfig.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)lruConfig);
        evConfig.addEvictionRegionConfig(evRegConfig);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        if (this.caches != null) {
            TestingUtil.killCaches(this.caches);
        }
        this.cache = null;
        this.caches = null;
        this.evController = null;
    }

    public void testHappyFlow() throws InterruptedException {
        this.cache.put(this.getSubFqn("/a"), (Object)"k_a", (Object)"v_a");
        this.cache.getNode(this.getSubFqn("/a")).setResident(true);
        this.cache.put(this.getSubFqn("/b"), (Object)"k_b", (Object)"v_b");
        this.cache.getNode(this.getSubFqn("/b")).setResident(true);
        this.cache.put(this.getSubFqn("/c"), (Object)"k_c", (Object)"v_c");
        this.cache.put(this.getSubFqn("/d"), (Object)"k_d", (Object)"v_d");
        this.cache.put(this.getSubFqn("/e"), (Object)"k_e", (Object)"v_e");
        this.cache.put(this.getSubFqn("/f"), (Object)"k_f", (Object)"v_f");
        this.cache.put(this.getSubFqn("/g"), (Object)"k_g", (Object)"v_g");
        this.cache.put(this.getSubFqn("/h"), (Object)"k_h", (Object)"v_h");
        this.cache.put(this.getSubFqn("/i"), (Object)"k_i", (Object)"v_i");
        this.evController.startEviction();
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/a")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/b")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/c")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/d")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/e")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/f")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/g")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/h")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/i")));
    }

    public void simpleTest() throws Exception {
        this.cache.put(this.getSubFqn("/a"), (Object)"k_a", (Object)"v_a");
        this.cache.put(this.getSubFqn("/b"), (Object)"k_b", (Object)"v_b");
        this.cache.put(this.getSubFqn("/c"), (Object)"k_c", (Object)"v_c");
        this.cache.put(this.getSubFqn("/d"), (Object)"k_d", (Object)"v_d");
        this.evController.startEviction();
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/a")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/b")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/c")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/d")));
    }

    public void testNoEvictionEventsForResidentNodes() throws InterruptedException {
        this.cache.put(this.getSubFqn("/a"), (Object)"k_a", (Object)"v_a");
        this.cache.put(this.getSubFqn("/b"), (Object)"k_b", (Object)"v_b");
        this.cache.getNode(this.getSubFqn("/a")).setResident(true);
        this.cache.getNode(this.getSubFqn("/b")).setResident(true);
        this.cache.put(this.getSubFqn("/c"), (Object)"k_c", (Object)"v_c");
        this.cache.put(this.getSubFqn("/d"), (Object)"k_d", (Object)"v_d");
        this.cache.put(this.getSubFqn("/e"), (Object)"k_e", (Object)"v_e");
        this.cache.put(this.getSubFqn("/f"), (Object)"k_f", (Object)"v_f");
        this.cache.put(this.getSubFqn("/g"), (Object)"k_g", (Object)"v_g");
        this.cache.put(this.getSubFqn("/h"), (Object)"k_h", (Object)"v_h");
        this.cache.getNode(this.getSubFqn("/a"));
        this.cache.getNode(this.getSubFqn("/b"));
        this.evController.startEviction();
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/a")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/b")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/c")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/d")));
        Assert.assertFalse((boolean)this.cache.exists(this.getSubFqn("/e")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/f")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/g")));
        Assert.assertTrue((boolean)this.cache.exists(this.getSubFqn("/h")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResidencyAndOptimisticLocking() throws Exception {
        Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        config.setCacheMode(Configuration.CacheMode.LOCAL);
        config.setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(config, true);
        cache.put(Fqn.fromString((String)"/a/b"), (Object)"key", (Object)"value");
        TransactionManager txManager = cache.getTransactionManager();
        txManager.begin();
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(true);
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.rollback();
        Assert.assertTrue((boolean)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        txManager.begin();
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(false);
        cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.commit();
        Assert.assertFalse((boolean)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        Assert.assertEquals((int)cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        try {
            if (cache.getTransactionManager().getTransaction() != null) {
                cache.getTransactionManager().rollback();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            cache.stop();
            throw throwable;
        }
        cache.stop();
    }

    public void testResidencyAndPessimisticLocking() throws Exception {
        this.cache.put(Fqn.fromString((String)"/a/b"), (Object)"key", (Object)"value");
        TransactionManager txManager = this.cache.getTransactionManager();
        assert (this.cache.getNumberOfLocksHeld() == 0) : "Should have no stale locks!";
        txManager.begin();
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(true);
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.rollback();
        Assert.assertTrue((boolean)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        assert (this.cache.getNumberOfLocksHeld() == 0) : "Should have no stale locks!";
        txManager.begin();
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).setResident(false);
        this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).put((Object)"k2", (Object)"v2");
        Assert.assertEquals((int)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
        txManager.commit();
        Assert.assertFalse((boolean)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).isResident());
        Assert.assertEquals((int)this.cache.getRoot().getChild(Fqn.fromString((String)"/a/b")).getKeys().size(), (int)2);
    }

    private Fqn getSubFqn(String str) {
        return Fqn.fromString((String)("/residentNodesTest" + str));
    }
}

