/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.batch;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.api.batch.AbstractBatchTest;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "transaction"}, testName="api.batch.BatchWithTM")
public class BatchWithTM
extends AbstractBatchTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchWithOngoingTM() throws Exception {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache();
            TransactionManager tm = this.getTransactionManager(cache);
            tm.begin();
            cache.put("/a/b/c", (Object)"k", (Object)"v");
            cache.startBatch();
            cache.put("/a/b/c", (Object)"k2", (Object)"v2");
            tm.commit();
            assert ("v".equals(cache.get("/a/b/c", (Object)"k")));
            assert ("v2".equals(cache.get("/a/b/c", (Object)"k2")));
            cache.endBatch(false);
            assert ("v".equals(cache.get("/a/b/c", (Object)"k")));
            assert ("v2".equals(cache.get("/a/b/c", (Object)"k2")));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            TestingUtil.killCaches(cache);
            cache = null;
            throw throwable;
        }
        TestingUtil.killCaches(cache);
        cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchWithoutOngoingTMSuspension() throws Exception {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache();
            TransactionManager tm = this.getTransactionManager(cache);
            assert (tm.getTransaction() == null) : "Should have no ongoing txs";
            cache.startBatch();
            cache.put("/a/b/c", (Object)"k", (Object)"v");
            assert (tm.getTransaction() == null) : "Should have no ongoing txs";
            cache.put("/a/b/c", (Object)"k2", (Object)"v2");
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k") == null);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k2") == null);
            try {
                tm.commit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            assert (tm.getTransaction() == null) : "Should have no ongoing txs";
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k") == null);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k2") == null);
            cache.endBatch(true);
            assert ("v".equals(this.getOnDifferentThread(cache, "/a/b/c", "k")));
            assert ("v2".equals(this.getOnDifferentThread(cache, "/a/b/c", "k2")));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TestingUtil.killCaches(cache);
            cache = null;
            throw throwable;
        }
        TestingUtil.killCaches(cache);
        cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchRollback() throws Exception {
        Cache<String, String> cache = null;
        try {
            cache = this.createCache();
            TransactionManager tm = this.getTransactionManager(cache);
            cache.startBatch();
            cache.put("/a/b/c", (Object)"k", (Object)"v");
            cache.put("/a/b/c", (Object)"k2", (Object)"v2");
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k") == null);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k2") == null);
            cache.endBatch(false);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k") == null);
            assert (this.getOnDifferentThread(cache, "/a/b/c", "k2") == null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            TestingUtil.killCaches(cache);
            cache = null;
            throw throwable;
        }
        TestingUtil.killCaches(cache);
        cache = null;
    }

    private TransactionManager getTransactionManager(Cache<String, String> c) {
        return c.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    private Cache<String, String> createCache() {
        UnitTestCacheFactory cf = new UnitTestCacheFactory();
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL);
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        c.setInvocationBatchingEnabled(true);
        assert (c.getTransactionManagerLookupClass() != null) : "Should have a transaction manager lookup class attached!!";
        return cf.createCache(c);
    }
}

