/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc;

import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.concurrent.locks.LockContainer;

public class LockAssert {
    public static void assertLocked(Fqn fqn, LockManager lockManager, InvocationContextContainer icc) {
        assert (lockManager.isLocked(fqn)) : fqn + " not locked!";
        assert (((InvocationContext)icc.get()).getLocks().contains(fqn)) : "Lock not recorded for " + fqn;
    }

    public static void assertNotLocked(Fqn fqn, LockManager lockManager, InvocationContextContainer icc) {
        assert (!((InvocationContext)icc.get()).getLocks().contains(fqn)) : fqn + " lock recorded!";
    }

    public static void assertNoLocks(LockManager lockManager, InvocationContextContainer icc) {
        LockContainer lc = (LockContainer)TestingUtil.extractField(lockManager, "lockContainer");
        assert (lc.getNumLocksHeld() == 0) : "Stale locks exist! NumLocksHeld is " + lc.getNumLocksHeld() + " and lock info is " + lockManager.printLockInfo();
        assert (((InvocationContext)icc.get()).getLocks().isEmpty()) : "Stale (?) locks recorded! " + ((InvocationContext)icc.get()).getLocks();
    }
}

