/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.api.NodeMoveAPITest;
import org.jboss.cache.api.mvcc.LockAssert;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional", "mvcc"})
public abstract class NodeMoveMvccTestBase
extends NodeMoveAPITest {
    static final Fqn A_B = Fqn.fromRelativeFqn((Fqn)A, (Fqn)B);
    static final Fqn A_B_C = Fqn.fromRelativeFqn((Fqn)A_B, (Fqn)C);
    static final Fqn A_B_C_E = Fqn.fromRelativeFqn((Fqn)A_B_C, (Fqn)E);
    static final Fqn A_B_D = Fqn.fromRelativeFqn((Fqn)A_B, (Fqn)D);
    static final Fqn C_E = Fqn.fromRelativeFqn((Fqn)C, (Fqn)E);
    static final Fqn D_B = Fqn.fromRelativeFqn((Fqn)D, (Fqn)B);
    static final Fqn D_B_C = Fqn.fromRelativeFqn((Fqn)D_B, (Fqn)C);

    public NodeMoveMvccTestBase() {
        this.nodeLockingScheme = Configuration.NodeLockingScheme.MVCC;
    }

    protected void checkLocks() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        LockManager lm = (LockManager)cr.getComponent(LockManager.class);
        InvocationContextContainer icc = (InvocationContextContainer)cr.getComponent(InvocationContextContainer.class);
        LockAssert.assertNotLocked(A, lm, icc);
        LockAssert.assertNotLocked(Fqn.ROOT, lm, icc);
        LockAssert.assertLocked(C, lm, icc);
        LockAssert.assertLocked(A_B, lm, icc);
        LockAssert.assertLocked(A_B_C, lm, icc);
    }

    protected void checkLocksDeep() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        LockManager lm = (LockManager)cr.getComponent(LockManager.class);
        InvocationContextContainer icc = (InvocationContextContainer)cr.getComponent(InvocationContextContainer.class);
        LockAssert.assertNotLocked(A, lm, icc);
        LockAssert.assertNotLocked(Fqn.ROOT, lm, icc);
        LockAssert.assertNotLocked(A_B_D, lm, icc);
        LockAssert.assertLocked(A_B, lm, icc);
        LockAssert.assertLocked(C, lm, icc);
        LockAssert.assertLocked(C_E, lm, icc);
        LockAssert.assertLocked(A_B_C, lm, icc);
        LockAssert.assertLocked(A_B_C_E, lm, icc);
    }

    protected void assertNoLocks() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry((Cache)cache);
        LockManager lm = (LockManager)cr.getComponent(LockManager.class);
        InvocationContextContainer icc = (InvocationContextContainer)cr.getComponent(InvocationContextContainer.class);
        LockAssert.assertNoLocks(lm, icc);
    }

    public void testNonexistentSource() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.put(A_B_C, (Object)"k", (Object)"v");
        assert ("v".equals(cache.get(A_B_C, (Object)"k")));
        assert (1 == cache.getNode(A_B).getChildren().size());
        assert (cache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (!cache.getNode(A_B).getChildrenNames().contains(D.getLastElement()));
        cache.move(D, A_B);
        assert ("v".equals(cache.get(A_B_C, (Object)"k")));
        assert (1 == cache.getNode(A_B).getChildren().size());
        assert (cache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (!cache.getNode(A_B).getChildrenNames().contains(D.getLastElement()));
    }

    public void testNonexistentTarget() {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.put(A_B_C, (Object)"k", (Object)"v");
        assert ("v".equals(cache.get(A_B_C, (Object)"k")));
        assert (1 == cache.getNode(A_B).getChildren().size());
        assert (cache.getNode(A_B).getChildrenNames().contains(C.getLastElement()));
        assert (null == cache.getNode(D));
        cache.move(A_B, D);
        assert (null == cache.getNode(A_B_C));
        assert (null == cache.getNode(A_B));
        assert (null != cache.getNode(D));
        assert (null != cache.getNode(D_B));
        assert (null != cache.getNode(D_B_C));
        assert ("v".equals(cache.get(D_B_C, (Object)"k")));
    }
}

