/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc.repeatable_read;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.api.mvcc.LockAssert;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "mvcc"}, sequential=true, testName="api.mvcc.repeatable_read.WriteSkewTest")
public class WriteSkewTest {
    protected Cache<String, String> cache;
    protected TransactionManager tm;
    protected Fqn A = Fqn.fromString((String)"/a");
    protected Fqn AB = Fqn.fromString((String)"/a/b");
    protected Fqn ABC = Fqn.fromString((String)"/a/b/c");
    protected Fqn ABCD = Fqn.fromString((String)"/a/b/c/d");
    protected LockManager lockManager;
    protected InvocationContextContainer icc;
    protected boolean repeatableRead = true;

    @BeforeMethod
    public void setUp() {
        this.cache = new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL), false);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.getConfiguration().setIsolationLevel(this.repeatableRead ? IsolationLevel.REPEATABLE_READ : IsolationLevel.READ_COMMITTED);
        this.cache.getConfiguration().setLockAcquisitionTimeout(200L);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
        this.icc = null;
        this.lockManager = null;
        this.tm = null;
    }

    private void postStart() {
        this.lockManager = (LockManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(LockManager.class);
        this.icc = (InvocationContextContainer)TestingUtil.extractComponentRegistry(this.cache).getComponent(InvocationContextContainer.class);
        this.tm = (TransactionManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(TransactionManager.class);
    }

    protected void assertNoLocks() {
        LockAssert.assertNoLocks(this.lockManager, this.icc);
    }

    public void testDontCheckWriteSkew() throws Exception {
        this.cache.getConfiguration().setWriteSkewCheck(false);
        this.cache.start();
        this.postStart();
        this.doTest(true);
    }

    public void testCheckWriteSkew() throws Exception {
        this.cache.getConfiguration().setWriteSkewCheck(true);
        this.cache.start();
        this.postStart();
        this.doTest(false);
    }

    private void doTest(final boolean allowWriteSkew) throws Exception {
        if (this.repeatableRead) {
            this.cache.put(this.AB, (Object)"k", (Object)"v");
            final HashSet w1exceptions = new HashSet();
            final HashSet w2exceptions = new HashSet();
            final CountDownLatch w1Signal = new CountDownLatch(1);
            final CountDownLatch w2Signal = new CountDownLatch(1);
            final CountDownLatch threadSignal = new CountDownLatch(2);
            Thread w1 = new Thread("Writer-1"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean didCoundDown = false;
                    try {
                        try {
                            WriteSkewTest.this.tm.begin();
                            assert ("v".equals(WriteSkewTest.this.cache.get(WriteSkewTest.this.AB, (Object)"k")));
                            threadSignal.countDown();
                            didCoundDown = true;
                            w1Signal.await();
                            WriteSkewTest.this.cache.put(WriteSkewTest.this.AB, (Object)"k", (Object)"v2");
                            WriteSkewTest.this.tm.commit();
                        }
                        catch (Exception e) {
                            w1exceptions.add(e);
                            Object var4_3 = null;
                            if (!didCoundDown) {
                                threadSignal.countDown();
                            }
                        }
                        Object var4_2 = null;
                        if (!didCoundDown) {
                            threadSignal.countDown();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (!didCoundDown) {
                            threadSignal.countDown();
                        }
                        throw throwable;
                    }
                }
            };
            Thread w2 = new Thread("Writer-2"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean didCoundDown = false;
                    try {
                        try {
                            WriteSkewTest.this.tm.begin();
                            assert ("v".equals(WriteSkewTest.this.cache.get(WriteSkewTest.this.AB, (Object)"k")));
                            threadSignal.countDown();
                            didCoundDown = true;
                            w2Signal.await();
                            WriteSkewTest.this.cache.put(WriteSkewTest.this.AB, (Object)"k", (Object)"v3");
                            WriteSkewTest.this.tm.commit();
                        }
                        catch (Exception e) {
                            w2exceptions.add(e);
                            if (!allowWriteSkew) {
                                try {
                                    WriteSkewTest.this.tm.rollback();
                                }
                                catch (SystemException systemException) {
                                }
                            }
                            Object var5_3 = null;
                            if (!didCoundDown) {
                                threadSignal.countDown();
                            }
                        }
                        Object var5_2 = null;
                        if (!didCoundDown) {
                            threadSignal.countDown();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        if (!didCoundDown) {
                            threadSignal.countDown();
                        }
                        throw throwable;
                    }
                }
            };
            w1.start();
            w2.start();
            threadSignal.await();
            w1Signal.countDown();
            w1.join();
            w2Signal.countDown();
            w2.join();
            if (allowWriteSkew) {
                this.throwExceptions(w1exceptions, w2exceptions);
                assert (w2exceptions.size() == 0);
                assert (w1exceptions.size() == 0);
                assert ("v3".equals(this.cache.get(this.AB, (Object)"k"))) : "W2 should have overwritten W1's work!";
            } else {
                assert (w2exceptions.size() == 1);
                this.throwExceptions(w1exceptions);
                assert (w1exceptions.size() == 0);
                assert ("v2".equals(this.cache.get(this.AB, (Object)"k"))) : "W2 should NOT have overwritten W1's work!";
            }
            this.assertNoLocks();
        }
    }

    private void throwExceptions(Collection<Exception> ... exceptions) throws Exception {
        for (Collection<Exception> ce : exceptions) {
            Iterator<Exception> i$ = ce.iterator();
            if (!i$.hasNext()) continue;
            Exception e = i$.next();
            throw e;
        }
    }
}

