/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.nodevalidity;

import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.api.nodevalidity.NodeValidityTestBase;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "pessimistic"}, testName="api.nodevalidity.LocalPessNodeValidityTest")
public class LocalPessNodeValidityTest
extends NodeValidityTestBase {
    private ThreadLocal<Cache<String, String>> cacheTL = new ThreadLocal();

    public LocalPessNodeValidityTest() {
        this.clustered = false;
        this.nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;
    }

    @Override
    @AfterMethod
    public void tearDown() {
        Cache<String, String> cache = this.cacheTL.get();
        super.tearDown();
        TestingUtil.killCaches(cache);
        this.cacheTL.set(null);
    }

    @Override
    protected Cache<String, String> createObserver() {
        return this.createModifier();
    }

    @Override
    protected Cache<String, String> createModifier() {
        Cache cache = this.cacheTL.get();
        if (cache == null) {
            UnitTestCacheFactory f = new UnitTestCacheFactory();
            cache = f.createCache(false);
            this.nodeLockingSchemeSpecificSetup(cache.getConfiguration());
            cache.start();
            this.cacheTL.set((Cache<String, String>)cache);
            return cache;
        }
        return cache;
    }
}

