/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.pfer;

import java.util.Map;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.api.pfer.PutForExternalReadTestBase;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;

public abstract class PFEROptimisticTestBase
extends PutForExternalReadTestBase {
    protected PFEROptimisticTestBase() {
        this.nodeLockingScheme = Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    protected void assertLocked(Fqn fqn, CacheSPI cache, boolean writeLocked) {
        TransactionTable tt = cache.getTransactionTable();
        GlobalTransaction gtx = tt.getCurrentTransaction();
        OptimisticTransactionContext otc = (OptimisticTransactionContext)cache.getTransactionTable().get(gtx);
        if (otc == null && gtx == null) {
            Map gtx2ContextMap = (Map)TestingUtil.extractField(tt, "gtx2ContextMap");
            assert (gtx2ContextMap.size() == 1) : "Can only attempt to access a suspended tx if there is only one such suspended tx!";
            gtx = (GlobalTransaction)gtx2ContextMap.keySet().iterator().next();
            otc = (OptimisticTransactionContext)gtx2ContextMap.get(gtx);
        }
        if (otc == null) {
            throw new NullPointerException("No transaction context available!");
        }
        TransactionWorkspace workspace = otc.getTransactionWorkSpace();
        AssertJUnit.assertNotNull((String)("node " + fqn + " should be in transaction workspace"), (Object)workspace.getNode(fqn));
    }
}

