/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.NullEvictionAlgorithmConfig;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="buddyreplication.EvictionOfBuddyBackupsTest")
public class EvictionOfBuddyBackupsTest
extends BuddyReplicationTestsBase {
    private CacheSPI cache1;
    private CacheSPI cache2;
    private Fqn fqn = Fqn.fromString((String)"/a/b/c");

    @BeforeMethod
    public void setUp() throws Exception {
        this.cache1 = this.createCache(1, null, true, false);
        this.cache1.getConfiguration().setEvictionConfig(this.getEvictionConfig());
        this.cache1.start();
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(this.cache1.getConfiguration().clone());
        TestingUtil.blockUntilViewsReceived(60000L, new Cache[]{this.cache1, this.cache2});
    }

    @AfterMethod
    public void tearDown() throws Exception {
        super.tearDown();
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        this.cache1 = null;
        this.cache2 = null;
    }

    private EvictionConfig getEvictionConfig() {
        EvictionConfig c = new EvictionConfig();
        EvictionRegionConfig defaultRegion = new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new NullEvictionAlgorithmConfig());
        c.setDefaultEvictionRegionConfig(defaultRegion);
        c.setWakeupInterval(1000L);
        LRUAlgorithmConfig lru = new LRUAlgorithmConfig(1000L, 1000L);
        EvictionRegionConfig subregion = new EvictionRegionConfig(this.fqn, (EvictionAlgorithmConfig)lru);
        c.addEvictionRegionConfig(subregion);
        return c;
    }

    public void testEvictionOfBackupRegions() throws Exception {
        this.cache1.put(this.fqn, (Object)"k", (Object)"v");
        assert (this.cache1.peek(this.fqn, false, false) != null) : "Node should exist";
        assert (this.cache2.peek(this.fqnTransformer.getBackupFqn(this.cache1.getLocalAddress(), this.fqn), false, false) != null) : "Node should exist on backup";
        TestingUtil.sleepThread(2000L);
        assert (this.cache1.peek(this.fqn, false, false) == null) : "Node should have evicted";
        assert (this.cache2.peek(this.fqnTransformer.getBackupFqn(this.cache1.getLocalAddress(), this.fqn), false, false) == null) : "Node should have evicted on backup";
    }
}

