/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import java.util.HashMap;
import org.easymock.EasyMock;
import org.jboss.cache.commands.legacy.write.PessRemoveKeyCommand;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.commands.write.AbstractVersionedDataCommandTest;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="commands.legacy.write.RemoveKeyCommandTest")
public class RemoveKeyCommandTest
extends AbstractVersionedDataCommandTest {
    PessRemoveKeyCommand command;
    private String key;

    public AbstractVersionedDataCommand moreSetUp() {
        this.key = "key";
        this.command = new PessRemoveKeyCommand(this.globalTransaction, this.fqn, (Object)this.key);
        return this.command;
    }

    public void testNonexistentNode() {
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn(null);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        this.control.verify();
    }

    public void testRemoveNonexistentPair() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("newKey", "newValue");
        this.nodes.adfgNode.putAll(expected);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfgNode);
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, this.ctx);
        expected = new HashMap();
        expected.put(this.key, null);
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, this.ctx);
        this.control.replay();
        assert (null == this.command.perform(this.ctx));
        assert (this.nodes.adfgNode.getData().size() == 1);
        assert ("newValue".equals(this.nodes.adfgNode.getData().get("newKey")));
        this.control.verify();
        this.control.reset();
        this.control.replay();
        this.command.rollback();
        assert (this.nodes.adfgNode.getData().size() == 1);
        assert ("newValue".equals(this.nodes.adfgNode.getData().get("newKey")));
        this.control.verify();
    }

    public void testRemoveExistentPair() {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(this.key, "newValue");
        this.nodes.adfgNode.putAll(expected);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfgNode);
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, this.ctx);
        EasyMock.expect((Object)this.notifier.shouldNotifyOnNodeModified()).andReturn((Object)true);
        this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, expected, this.ctx);
        this.control.replay();
        assert ("newValue" == this.command.perform(this.ctx));
        assert (this.nodes.adfgNode.getData().get(this.key) == null);
        this.control.verify();
        this.control.reset();
        EasyMock.expect((Object)this.container.peek(this.fqn, false, true)).andReturn((Object)this.nodes.adfgNode);
        this.control.replay();
        this.command.rollback();
        assert (this.nodes.adfgNode.getData().size() == 1);
        assert ("newValue".equals(this.nodes.adfgNode.getData().get(this.key)));
        this.control.verify();
    }

    public void testRollbackOnNoOp() {
        EasyMock.expect((Object)this.container.peek(this.fqn, false, true)).andReturn(null);
        this.control.replay();
        this.command.rollback();
    }
}

