/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.legacy.write.LegacyEvictCommand;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.notifications.Notifier;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="commands.write.EvictCommandTest")
public class EvictCommandTest
extends AbstractDataCommandTest {
    EvictCommand command;
    Notifier notifier;
    IMocksControl control;
    MockNodesFixture nodes;

    protected void moreSetup() {
        this.control = EasyMock.createStrictControl();
        this.notifier = (Notifier)this.control.createMock(Notifier.class);
        this.container = (DataContainer)this.control.createMock(DataContainer.class);
        this.command = new LegacyEvictCommand(this.testFqn);
        this.command.initialize(this.notifier, this.container);
        this.nodes = new MockNodesFixture();
    }

    public void testResidentNodesEviction() {
        this.nodes.abNode.setResident(true);
        EasyMock.expect((Object)this.container.peek(this.testFqn, false, true)).andReturn((Object)this.nodes.abNode);
        this.control.replay();
        assert (Boolean.TRUE == this.command.perform(this.ctx));
        this.control.verify();
    }

    public void testSimpleEviction() {
        EasyMock.expect((Object)this.container.peek(this.testFqn, false, true)).andReturn((Object)this.nodes.abNode);
        this.notifier.notifyNodeEvicted(this.testFqn, true, this.ctx);
        this.notifier.notifyNodeEvicted(this.testFqn, false, this.ctx);
        this.control.replay();
        assert (Boolean.FALSE == this.command.perform(this.ctx));
        this.control.verify();
    }

    public void testRecursiveEviction() {
        ArrayList<Fqn> nodesToEvict = new ArrayList<Fqn>();
        nodesToEvict.add(this.nodes.a);
        nodesToEvict.add(this.nodes.ab);
        this.command.setRecursive(true);
        EasyMock.expect((Object)this.container.peek(this.testFqn, false, true)).andReturn((Object)this.nodes.aNode);
        EasyMock.expect((Object)this.container.getNodesForEviction(this.testFqn, true)).andReturn(nodesToEvict);
        this.control.checkOrder(false);
        EasyMock.expect((Object)this.container.peek(this.nodes.a, false, true)).andReturn((Object)this.nodes.aNode);
        this.notifier.notifyNodeEvicted(this.nodes.a, true, this.ctx);
        this.notifier.notifyNodeEvicted(this.nodes.a, false, this.ctx);
        EasyMock.expect((Object)this.container.peek(this.nodes.ab, false, true)).andReturn((Object)this.nodes.abNode);
        this.notifier.notifyNodeEvicted(this.nodes.ab, true, this.ctx);
        this.notifier.notifyNodeEvicted(this.nodes.ab, false, this.ctx);
        this.control.replay();
        assert (Boolean.TRUE == this.command.perform(this.ctx));
        this.control.verify();
    }
}

