/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.ConfigurationCloningTest")
public class ConfigurationCloningTest {
    public static final String DEFAULT_CONFIGURATION_FILE = "configs/clonable-config.xml";
    private static final Log log = LogFactory.getLog(ConfigurationCloningTest.class);

    public void testClone() throws Exception {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        Configuration c = parser.parseFile(DEFAULT_CONFIGURATION_FILE);
        try {
            RuntimeConfig rc2;
            CacheLoaderConfig clc2;
            Configuration clone = c.clone();
            AssertJUnit.assertEquals((Object)Configuration.NodeLockingScheme.OPTIMISTIC, (Object)clone.getNodeLockingScheme());
            AssertJUnit.assertEquals((Object)Configuration.CacheMode.REPL_SYNC, (Object)clone.getCacheMode());
            AssertJUnit.assertEquals((String)"CloneCluster", (String)clone.getClusterName());
            AssertJUnit.assertEquals((String)c.getClusterConfig(), (String)clone.getClusterConfig());
            AssertJUnit.assertEquals((long)3L, (long)clone.getStateRetrievalTimeout());
            EvictionConfig ec1 = c.getEvictionConfig();
            EvictionConfig ec2 = clone.getEvictionConfig();
            AssertJUnit.assertFalse((ec1 == ec2 ? 1 : 0) != 0);
            AssertJUnit.assertEquals((int)4, (int)ec2.getDefaultEvictionRegionConfig().getEventQueueSize());
            AssertJUnit.assertEquals((long)45000L, (long)ec2.getWakeupInterval());
            assert (ec2.getDefaultEvictionRegionConfig().getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig);
            List ercs1 = ec1.getEvictionRegionConfigs();
            List ercs2 = ec2.getEvictionRegionConfigs();
            AssertJUnit.assertEquals((int)ercs1.size(), (int)ercs2.size());
            for (int i = 0; i < ercs1.size(); ++i) {
                this.compareEvictionRegionConfigs((EvictionRegionConfig)ercs1.get(i), (EvictionRegionConfig)ercs2.get(i));
            }
            CacheLoaderConfig clc1 = c.getCacheLoaderConfig();
            AssertJUnit.assertFalse((clc1 == (clc2 = clone.getCacheLoaderConfig()) ? 1 : 0) != 0);
            AssertJUnit.assertFalse((boolean)clc2.isPassivation());
            AssertJUnit.assertTrue((boolean)clc2.isShared());
            List clcs1 = clc1.getIndividualCacheLoaderConfigs();
            List clcs2 = clc2.getIndividualCacheLoaderConfigs();
            AssertJUnit.assertEquals((int)clcs1.size(), (int)clcs2.size());
            for (int i = 0; i < clcs1.size(); ++i) {
                this.compareCacheLoaderConfigs((CacheLoaderConfig.IndividualCacheLoaderConfig)clcs1.get(i), (CacheLoaderConfig.IndividualCacheLoaderConfig)clcs2.get(i));
            }
            RuntimeConfig rc1 = c.getRuntimeConfig();
            AssertJUnit.assertFalse((rc1 == (rc2 = clone.getRuntimeConfig()) ? 1 : 0) != 0);
            AssertJUnit.assertEquals((Object)rc1, (Object)rc2);
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            AssertJUnit.fail((String)("Cloning failed -- " + e.getMessage()));
        }
    }

    private void compareEvictionRegionConfigs(EvictionRegionConfig erc1, EvictionRegionConfig erc2) {
        AssertJUnit.assertEquals((String)erc1.getRegionName(), (String)erc2.getRegionName());
        AssertJUnit.assertEquals((Object)erc1.getRegionFqn(), (Object)erc2.getRegionFqn());
        AssertJUnit.assertEquals((int)erc1.getEventQueueSize(), (int)erc2.getEventQueueSize());
        EvictionAlgorithmConfig epc1 = erc1.getEvictionAlgorithmConfig();
        EvictionAlgorithmConfig epc2 = erc2.getEvictionAlgorithmConfig();
        AssertJUnit.assertFalse((epc1 == epc2 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)epc1, (Object)epc2);
    }

    private void compareCacheLoaderConfigs(CacheLoaderConfig.IndividualCacheLoaderConfig clc1, CacheLoaderConfig.IndividualCacheLoaderConfig clc2) {
        AssertJUnit.assertFalse((clc1 == clc2 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)clc1, (Object)clc2);
        Properties p1 = clc1.getProperties();
        Properties p2 = clc2.getProperties();
        AssertJUnit.assertFalse((p1 == p2 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)p1, (Object)p2);
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc1 = clc1.getSingletonStoreConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc2 = clc2.getSingletonStoreConfig();
        AssertJUnit.assertFalse((ssc1 == ssc2 ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)ssc1, (Object)ssc2);
    }
}

