/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.parsing.ConfigFilesConvertor;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.config.parsing.XmlConfigurationParser2x;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ConfigurationTransformerTest {
    public static final String XSLT_FILE = "config2to3.xslt";
    private static final String BASE_DIR = "configs/conf2x";
    ConfigFilesConvertor convertor = new ConfigFilesConvertor();

    public void testSingleFile() throws Exception {
        String fileName = this.getFileName("/policyPerRegion-eviction.xml");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE);
        System.out.println("result = \n" + baos);
        XmlConfigurationParser newParser = new XmlConfigurationParser();
        XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
        Configuration newConfig = newParser.parseStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Configuration oldConfig = oldParser.parseFile(fileName);
        assert (oldConfig.equals((Object)newConfig));
    }

    public void testEqualityOnTransformedFiles() throws Exception {
        String[] fileNames;
        for (String file : fileNames = new String[]{"buddy-replication-cache.xml", "local-cache.xml", "multiplexer-enabled-cache.xml", "total-replication-cache.xml"}) {
            System.out.println("Processing file = " + file);
            String fileName = this.getFileName(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE);
            System.out.println("result = \n" + baos);
            XmlConfigurationParser newParser = new XmlConfigurationParser();
            XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
            Configuration newConfig = newParser.parseStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            Configuration oldConfig = oldParser.parseFile(fileName);
            assert (newConfig.equals((Object)oldConfig));
        }
    }

    public void testEqualityOnEvictionTransformedFiles() throws Exception {
        String[] fileNames;
        for (String file : fileNames = new String[]{"cacheloader-enabled-cache.xml", "clonable-config.xml", "default-test-config2x.xml", "eviction-enabled-cache.xml", "optimistically-locked-cache.xml", "policyPerRegion-eviction.xml"}) {
            System.out.println("Processing file = " + file);
            String fileName = this.getFileName(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE);
            System.out.println("result = \n" + baos);
            XmlConfigurationParser newParser = new XmlConfigurationParser();
            XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
            Configuration newConfig = newParser.parseStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            Configuration oldConfig = oldParser.parseFile(fileName);
            assert (newConfig.equals((Object)oldConfig));
        }
    }

    public void testUnlimitedValues() throws Exception {
        String fileName = this.getFileName("/zeroTTL.xml");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.convertor.parse(fileName, (OutputStream)baos, XSLT_FILE);
        System.out.println("result = \n" + baos);
        XmlConfigurationParser newParser = new XmlConfigurationParser();
        XmlConfigurationParser2x oldParser = new XmlConfigurationParser2x();
        Configuration newConfig = newParser.parseStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Configuration oldConfig = oldParser.parseFile(fileName);
        for (EvictionRegionConfig erc : oldConfig.getEvictionConfig().getEvictionRegionConfigs()) {
            this.correctUnlimitedValues(erc);
        }
        this.correctUnlimitedValues(oldConfig.getEvictionConfig().getDefaultEvictionRegionConfig());
        assert (oldConfig.equals((Object)newConfig));
    }

    private void correctUnlimitedValues(EvictionRegionConfig erc) {
        LRUAlgorithmConfig eac = (LRUAlgorithmConfig)erc.getEvictionAlgorithmConfig();
        if (eac.getMaxAge() <= 0L) {
            eac.setMaxAge(-1L);
        }
        if (eac.getMaxNodes() <= 0) {
            eac.setMaxNodes(-1);
        }
        if (eac.getMinTimeToLive() <= 0L) {
            eac.setMinTimeToLive(-1L);
        }
        if (eac.getTimeToLive() <= 0L) {
            eac.setTimeToLive(-1L);
        }
    }

    private String getFileName(String s) {
        return BASE_DIR + File.separator + s;
    }
}

