/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.StringPropertyReplacementTest")
public class StringPropertyReplacementTest {
    public static final String STRING_REPLACED_FILE = "configs/string-property-replaced.xml";
    private static final String PROP_BASE = "test.property.";
    private static final String SYNC_COMMIT_PROP = "test.property.SyncCommitPhase";
    private static final String NUM_BUDDIES_PROP = "test.property.BuddyReplicationConfig.numBuddies";
    private static final String MAX_NODES_PROP = "test.property.EvictionPolicyConfig.maxNodes";
    private static final String BUDDY_POOL_PROP = "test.property.BuddyReplicationConfig.buddyPoolName";
    private String numBuddies;
    private String syncCommitPhase;
    private String maxNodes;
    private String buddyPoolName;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.numBuddies = System.getProperty(NUM_BUDDIES_PROP);
        this.syncCommitPhase = System.getProperty(SYNC_COMMIT_PROP);
        this.maxNodes = System.getProperty(MAX_NODES_PROP);
        this.buddyPoolName = System.getProperty(BUDDY_POOL_PROP);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.numBuddies == null) {
            System.clearProperty(NUM_BUDDIES_PROP);
        } else {
            System.setProperty(NUM_BUDDIES_PROP, this.numBuddies);
        }
        if (this.syncCommitPhase == null) {
            System.clearProperty(SYNC_COMMIT_PROP);
        } else {
            System.setProperty(SYNC_COMMIT_PROP, this.syncCommitPhase);
        }
        if (this.maxNodes == null) {
            System.clearProperty(MAX_NODES_PROP);
        } else {
            System.setProperty(MAX_NODES_PROP, this.maxNodes);
        }
        if (this.buddyPoolName == null) {
            System.clearProperty(BUDDY_POOL_PROP);
        } else {
            System.setProperty(BUDDY_POOL_PROP, this.buddyPoolName);
        }
    }

    public void testStringPropertyReplacement() throws Exception {
        System.setProperty(NUM_BUDDIES_PROP, "3");
        System.setProperty(SYNC_COMMIT_PROP, "false");
        System.setProperty(MAX_NODES_PROP, "1000");
        System.setProperty(BUDDY_POOL_PROP, "replaced");
        Configuration cfg = new XmlConfigurationParser().parseFile(STRING_REPLACED_FILE);
        AssertJUnit.assertEquals((Object)Configuration.NodeLockingScheme.MVCC, (Object)cfg.getNodeLockingScheme());
        AssertJUnit.assertFalse((boolean)cfg.isSyncCommitPhase());
        AssertJUnit.assertTrue((boolean)cfg.isSyncRollbackPhase());
        AssertJUnit.assertEquals((long)15000L, (long)cfg.getLockAcquisitionTimeout());
        String clusterCfg = cfg.getClusterConfig();
        AssertJUnit.assertTrue((clusterCfg == null || clusterCfg.length() == 0 ? 1 : 0) != 0);
        EvictionConfig ec = cfg.getEvictionConfig();
        assert (ec.getDefaultEvictionRegionConfig().getEvictionAlgorithmConfig() instanceof LRUAlgorithmConfig);
        EvictionRegionConfig erc = ec.getDefaultEvictionRegionConfig();
        LRUAlgorithmConfig epc = (LRUAlgorithmConfig)erc.getEvictionAlgorithmConfig();
        AssertJUnit.assertEquals((int)1000, (int)epc.getMaxNodes());
        CacheLoaderConfig clc = cfg.getCacheLoaderConfig();
        CacheLoaderConfig.IndividualCacheLoaderConfig iclc = clc.getFirstCacheLoaderConfig();
        AssertJUnit.assertEquals((Object)System.getProperty("java.io.tmpdir"), (Object)iclc.getProperties().get("location"));
        BuddyReplicationConfig brc = cfg.getBuddyReplicationConfig();
        AssertJUnit.assertTrue((boolean)brc.isEnabled());
        AssertJUnit.assertEquals((String)"replaced", (String)brc.getBuddyPoolName());
        BuddyReplicationConfig.BuddyLocatorConfig blc = brc.getBuddyLocatorConfig();
        AssertJUnit.assertEquals((Object)"3", (Object)blc.getBuddyLocatorProperties().get("numBuddies"));
    }
}

