/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.BuddyElementParser;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"}, sequential=true, testName="config.parsing.BuddyElementParserTest")
public class BuddyElementParserTest {
    BuddyElementParser parser = new BuddyElementParser();

    public void testDefaultValues() throws Exception {
        String xmlConfig = "<buddyReplication enabled=\"true\"/>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xmlConfig);
        BuddyReplicationConfig brConfig = this.parser.parseBuddyElement(element);
        assert (brConfig.getBuddyLocatorConfig().getClassName().equals(NextMemberBuddyLocator.class.getName())) : "default buddy locator class is NextMemberBuddyLocator";
        assert (brConfig.getBuddyLocatorConfig().getBuddyLocatorProperties().isEmpty());
        assert (brConfig.isDataGravitationRemoveOnFind()) : "default to true";
        assert (brConfig.isDataGravitationSearchBackupTrees()) : "default to true";
        assert (brConfig.isAutoDataGravitation()) : "default to false";
    }

    public void testDefaultParamsForNextMemberBuddyLocator() throws Exception {
        String xmlConfig = "   <buddyReplication enabled=\"true\" poolName=\"groupOne\">\n      <locator>\n         <properties>\n            numBuddies = 3\n         </properties>\n      </locator>\n   </buddyReplication>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xmlConfig);
        BuddyReplicationConfig brConfig = this.parser.parseBuddyElement(element);
        assert (brConfig.getBuddyLocatorConfig().getClassName().equals(NextMemberBuddyLocator.class.getName())) : "default buddy locator class is NextMemberBuddyLocator";
        assert (brConfig.getBuddyLocatorConfig().getBuddyLocatorProperties().get("numBuddies").equals("3"));
        assert (brConfig.getBuddyLocatorConfig().getBuddyLocatorProperties().size() == 1);
    }

    public void testNormalConfig() throws Exception {
        String xmlConfig = "   <buddyReplication enabled=\"true\" poolName=\"groupOne\">\n      <locator>\n         <properties>\n            numBuddies = 3\n         </properties>\n      </locator>\n   </buddyReplication>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xmlConfig);
        BuddyReplicationConfig brConfig = this.parser.parseBuddyElement(element);
        assert (brConfig.isEnabled());
        assert (brConfig.getBuddyPoolName().equals("groupOne"));
        assert (brConfig.getBuddyLocatorConfig().getBuddyLocatorProperties().get("numBuddies").equals("3"));
    }
}

