/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import org.jboss.cache.Fqn;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.XmlConfigurationParser2x;
import org.jboss.cache.config.parsing.element.EvictionElementParser;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"}, testName="config.parsing.Eviction2xto3xCompatibilityTest")
public class Eviction2xto3xCompatibilityTest {
    private EvictionElementParser evictionElementParser;

    @BeforeMethod
    public void setUp() {
        this.evictionElementParser = new EvictionElementParser();
    }

    public void testDefaultValues1() throws Exception {
        String oldFormat = "      <attribute name=\"EvictionPolicyConfig\">\n         <config>\n            <attribute name=\"wakeUpIntervalSeconds\">5</attribute>\n            <attribute name=\"eventQueueSize\">200000</attribute>\n            <attribute name=\"policyClass\">org.jboss.cache.eviction.LRUPolicy</attribute>\n            <region name=\"/_default_\" eventQueueSize=\"1234\" policyClass=\"org.jboss.cache.eviction.MRUPolicy\">\n               <attribute name=\"maxNodes\">5001</attribute>\n               <attribute name=\"minTimeToLiveSeconds\">1001</attribute>\n            </region>\n            <region name=\"/org/jboss/data\">\n               <attribute name=\"minTimeToLiveSeconds\">1000</attribute>\n               <attribute name=\"maxNodes\">5000</attribute>\n            </region>\n         </config>\n      </attribute>";
        Element oldEl = XmlConfigHelper.stringToElementInCoreNS((String)oldFormat);
        EvictionConfig oldEvConfig = XmlConfigurationParser2x.parseEvictionConfig((Element)oldEl);
        MRUAlgorithmConfig defaultAlgorithmConfig = (MRUAlgorithmConfig)oldEvConfig.getDefaultEvictionRegionConfig().getEvictionAlgorithmConfig();
        assert (oldEvConfig.getDefaultEvictionRegionConfig().getEventQueueSize() == 1234);
        assert (defaultAlgorithmConfig.getEvictionAlgorithmClassName().equals("org.jboss.cache.eviction.MRUAlgorithm"));
        assert (defaultAlgorithmConfig.getMaxNodes() == 5001);
        assert (defaultAlgorithmConfig.getMinTimeToLive() == 1001000L);
        assert (oldEvConfig.getEvictionRegionConfigs().size() == 1);
        EvictionRegionConfig orgJbossData = (EvictionRegionConfig)oldEvConfig.getEvictionRegionConfigs().get(0);
        assert (orgJbossData.getRegionFqn().equals((Object)Fqn.fromString((String)"org/jboss/data")));
        assert (orgJbossData.getEvictionAlgorithmConfig().getEvictionAlgorithmClassName().equals("org.jboss.cache.eviction.LRUAlgorithm"));
        assert (orgJbossData.getEventQueueSize() == 200000);
    }

    public void simpleTest() throws Exception {
        String oldFormat = "      <attribute name=\"EvictionPolicyConfig\">\n         <config>\n            <attribute name=\"wakeUpIntervalSeconds\">5</attribute>\n            <attribute name=\"eventQueueSize\">200000</attribute>\n            <attribute name=\"policyClass\">org.jboss.cache.eviction.LRUPolicy</attribute>\n            <region name=\"/_default_\">\n               <attribute name=\"maxNodes\">5000</attribute>\n               <attribute name=\"timeToLiveSeconds\">1000</attribute>\n            </region>\n            <region name=\"/org/jboss/data\"  policyClass=\"org.jboss.cache.eviction.LFUPolicy\">\n               <attribute name=\"minTimeToLiveSeconds\">1000</attribute>\n               <attribute name=\"maxNodes\">5000</attribute>\n            </region>\n         </config>\n      </attribute>";
        String newFormat = "<eviction wakeUpInterval=\"5000\">\n  <default algorithmClass=\"org.jboss.cache.eviction.LRUAlgorithm\" eventQueueSize=\"200000\">\n     <property name=\"maxNodes\" value=\"5000\"></property>\n     <property name=\"timeToLive\" value=\"1000000\"></property>\n  </default>\n  <region name=\"/org/jboss/data\" algorithmClass=\"org.jboss.cache.eviction.LFUAlgorithm\" eventQueueSize=\"200000\">\n     <property name=\"minTimeToLive\" value=\"1000000\"></property>\n     <property name=\"maxNodes\" value=\"5000\"></property>\n  </region>\n</eviction>";
        Element oldEl = XmlConfigHelper.stringToElementInCoreNS((String)oldFormat);
        Element newEl = XmlConfigHelper.stringToElementInCoreNS((String)newFormat);
        EvictionConfig oldEvConfig = XmlConfigurationParser2x.parseEvictionConfig((Element)oldEl);
        EvictionConfig newEvConfig = this.evictionElementParser.parseEvictionElement(newEl);
        assert (oldEvConfig.getDefaultEvictionRegionConfig().equals((Object)newEvConfig.getDefaultEvictionRegionConfig()));
        EvictionRegionConfig oldRegionConfig = (EvictionRegionConfig)oldEvConfig.getEvictionRegionConfigs().get(0);
        EvictionRegionConfig newRegionConfig = (EvictionRegionConfig)newEvConfig.getEvictionRegionConfigs().get(0);
        EvictionAlgorithmConfig oldEvictionAlgorithmConfig = oldRegionConfig.getEvictionAlgorithmConfig();
        EvictionAlgorithmConfig newEvictionAlgorithmConfig = newRegionConfig.getEvictionAlgorithmConfig();
        assert (oldEvictionAlgorithmConfig.equals(newEvictionAlgorithmConfig));
        assert (oldEvConfig.equals((Object)newEvConfig));
    }

    public void testFailureOnCustomEvictionPolicy() throws Exception {
        String oldFormat = "      <attribute name=\"EvictionPolicyConfig\">\n         <config>\n            <attribute name=\"wakeUpIntervalSeconds\">5</attribute>\n            <attribute name=\"eventQueueSize\">200000</attribute>\n            <attribute name=\"policyClass\">org.jboss.cache.eviction.LRUPolicy</attribute>\n            <region name=\"/_default_\">\n               <attribute name=\"maxNodes\">5000</attribute>\n               <attribute name=\"timeToLiveSeconds\">1000</attribute>\n            </region>\n            <region name=\"/org/jboss/data\"  policyClass=\"org.custom.eviction.policy.LFUPolicy\">\n               <attribute name=\"minTimeToLiveSeconds\">1000</attribute>\n               <attribute name=\"maxNodes\">5000</attribute>\n            </region>\n         </config>\n      </attribute>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)oldFormat);
        try {
            XmlConfigurationParser2x.parseEvictionConfig((Element)element);
            assert (false) : "custom eviction config not supported for the old parser";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void testFailureOnCustomDefaultEvictionPolicy() throws Exception {
        String oldFormat = "      <attribute name=\"EvictionPolicyConfig\">\n         <config>\n            <attribute name=\"wakeUpIntervalSeconds\">5</attribute>\n            <attribute name=\"eventQueueSize\">200000</attribute>\n            <attribute name=\"policyClass\">org.custom.eviction.policy.LFUPolicy</attribute>\n            <region name=\"/_default_\">\n               <attribute name=\"maxNodes\">5000</attribute>\n               <attribute name=\"timeToLiveSeconds\">1000</attribute>\n            </region>\n            <region name=\"/org/jboss/data\" policyClass=\"org.jboss.cache.eviction.LRUPolicy\">\n               <attribute name=\"minTimeToLiveSeconds\">1000</attribute>\n               <attribute name=\"maxNodes\">5000</attribute>\n            </region>\n         </config>\n      </attribute>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)oldFormat);
        try {
            XmlConfigurationParser2x.parseEvictionConfig((Element)element);
            assert (false) : "default custom eviction config not supported for the old parser";
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

