/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.ElementSizeAlgorithm;
import org.jboss.cache.eviction.ElementSizeAlgorithmConfig;
import org.jboss.cache.eviction.ElementSizeQueue;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.NodeEntry;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="eviction.ElementSizeAlgorithmTest")
public class ElementSizeAlgorithmTest
extends EvictionTestsBase {
    RegionManager regionManager;
    ElementSizeAlgorithm algo;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManagerImpl();
        ElementSizeAlgorithmConfig config = new ElementSizeAlgorithmConfig();
        config.setMaxElementsPerNode(0);
        this.algo = (ElementSizeAlgorithm)this.createAndAssignToRegion("/a/b", this.regionManager, (EvictionAlgorithmConfig)config);
    }

    public void testMaxElements() throws Exception {
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        ElementSizeAlgorithmConfig config = (ElementSizeAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(10);
        config.setMaxElementsPerNode(6);
        for (int i = 0; i < 10; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
            if (i % 2 != 0) continue;
            for (int k = 0; k < i; ++k) {
                region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_ELEMENT_EVENT);
            }
        }
        this.algo.process(region.getEvictionEventQueue());
        ElementSizeQueue queue = (ElementSizeQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)9, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        AssertJUnit.assertEquals((int)12, (int)this.algo.getEvictionQueue().getNumberOfElements());
        int count = 6;
        for (NodeEntry ne : queue) {
            System.out.println(ne);
            if (count > 0) {
                AssertJUnit.assertEquals((int)count, (int)ne.getNumberOfElements());
            } else {
                AssertJUnit.assertEquals((int)0, (int)ne.getNumberOfElements());
            }
            count -= 2;
        }
        for (int i = 0; i < 7; ++i) {
            region.registerEvictionEvent(Fqn.fromString((String)"/a/b/9"), EvictionEvent.Type.ADD_ELEMENT_EVENT);
            region.registerEvictionEvent(Fqn.fromString((String)"/a/b/7"), EvictionEvent.Type.ADD_ELEMENT_EVENT);
        }
        this.algo.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((int)7, (int)queue.getNumberOfNodes());
    }

    public void testMaxNodesAndMaxElements() throws Exception {
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        ElementSizeAlgorithmConfig config = (ElementSizeAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(10);
        config.setMaxElementsPerNode(100);
        for (int i = 0; i < 20; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
            for (int k = 0; k < i; ++k) {
                region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_ELEMENT_EVENT);
            }
        }
        this.algo.process(region.getEvictionEventQueue());
        ElementSizeQueue queue = (ElementSizeQueue)this.algo.evictionQueue;
        AssertJUnit.assertEquals((int)10, (int)this.algo.getEvictionQueue().getNumberOfNodes());
        AssertJUnit.assertEquals((int)45, (int)this.algo.getEvictionQueue().getNumberOfElements());
        int num = 9;
        for (NodeEntry ne : queue) {
            AssertJUnit.assertEquals((int)num, (int)ne.getNumberOfElements());
            --num;
        }
    }
}

