/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.RegionRegistry;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionWatcher;

public abstract class EvictionTestsBase {
    public EvictionAlgorithm createAndAssignToRegion(String fqnString, RegionManager regionManager, EvictionAlgorithmConfig config) {
        Fqn fqn = Fqn.fromString((String)fqnString);
        Configuration c = new Configuration();
        c.setEvictionConfig(new EvictionConfig());
        EvictionRegionConfig erc = new EvictionRegionConfig(fqn, config);
        c.getEvictionConfig().addEvictionRegionConfig(erc);
        CacheSPI mockCache = (CacheSPI)EasyMock.createNiceMock(CacheSPI.class);
        EasyMock.replay((Object[])new Object[]{mockCache});
        ((RegionManagerImpl)regionManager).injectDependencies(mockCache, c, null, null, null, new RegionRegistry());
        Region r = regionManager.getRegion(fqn, Region.Type.EVICTION, true);
        r.setEvictionRegionConfig(erc);
        ((RegionManagerImpl)regionManager).start();
        return (EvictionAlgorithm)TestingUtil.extractField(r, "evictionAlgorithm");
    }

    public boolean waitForEviction(Cache cache, long timeToWait, TimeUnit unit, Fqn ... fqnsToEvict) throws InterruptedException {
        return new EvictionWatcher(cache, fqnsToEvict).waitForEviction(timeToWait, unit);
    }
}

