/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.element.EvictionElementParser;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"unit"}, sequential=false, testName="eviction.LRUConfigurationTest")
public class LRUConfigurationTest {
    public void testXMLParsing() throws Exception {
        LRUAlgorithmConfig config = new LRUAlgorithmConfig();
        String xml = "<region name=\"/org/jboss/data\">\n<property name=\"maxNodes\" value=\"5000\"></property>\n<property name=\"timeToLive\" value=\"1000\"></property>\n</region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)5000, (int)config.getMaxNodes());
        AssertJUnit.assertEquals((long)1000L, (long)config.getTimeToLive());
    }

    public void testXMLParsing2() throws Exception {
        LRUAlgorithmConfig config = new LRUAlgorithmConfig();
        String xml = "<region name=\"/maxAgeTest/\">\n<property name=\"maxNodes\" value=\"10000\"></property>\n<property name=\"timeToLive\" value=\"1000\"></property>\n<property name=\"maxAge\" value=\"10\"></property>\n</region>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        EvictionElementParser.parseEvictionPolicyConfig((Element)element, (EvictionAlgorithmConfig)config);
        config.validate();
        AssertJUnit.assertEquals((int)10000, (int)config.getMaxNodes());
        AssertJUnit.assertEquals((long)1000L, (long)config.getTimeToLive());
        AssertJUnit.assertEquals((long)10L, (long)config.getMaxAge());
    }

    public void testXMLParsing3() throws Exception {
        String xml = "<eviction wakeupInterval=\"30\"><region name=\"/maxAgeTest/\">\n<property name=\"maxNodes\" value=\"10000\"></property>\n<property name=\"maxAge\" value=\"10\"></property>\n</region></eviction>";
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xml);
        boolean caught = false;
        try {
            EvictionConfig ec = new EvictionElementParser().parseEvictionElement(element);
            ((EvictionRegionConfig)ec.getEvictionRegionConfigs().get(0)).validate();
        }
        catch (ConfigurationException ce) {
            caught = true;
        }
        AssertJUnit.assertTrue((String)"Configure exception should have been caught", (boolean)caught);
    }
}

