/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.EvictionController;
import org.jboss.cache.util.internals.EvictionWatcher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.LRUPolicyTest")
public class LRUPolicyTest
extends EvictionTestsBase {
    CacheSPI<Object, Object> cache;
    long wakeupIntervalMillis = 200L;
    long dataRegionTTLMillis = 200L;
    long testRegionTTLMillis = 200L;
    private int baseRegionMaxNodes = 10;
    private int baseRegionTTLMillis = 200;
    final String ROOT_STR = "/test";
    Throwable t1_ex;
    Throwable t2_ex;
    boolean isTrue;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        EvictionConfig evConfig = conf.getEvictionConfig();
        evConfig.setWakeupInterval(this.wakeupIntervalMillis);
        ArrayList<EvictionRegionConfig> regionConfigs = new ArrayList<EvictionRegionConfig>();
        regionConfigs.add(new EvictionRegionConfig(Fqn.fromString((String)"/org/jboss/test/data"), (EvictionAlgorithmConfig)new LRUAlgorithmConfig(this.dataRegionTTLMillis, -1L, 5)));
        regionConfigs.add(new EvictionRegionConfig(Fqn.fromString((String)"/test"), (EvictionAlgorithmConfig)new LRUAlgorithmConfig(this.testRegionTTLMillis, 10000L)));
        regionConfigs.add(new EvictionRegionConfig(Fqn.fromString((String)"/base"), (EvictionAlgorithmConfig)new LRUAlgorithmConfig((long)this.baseRegionTTLMillis, -1L, this.baseRegionMaxNodes)));
        evConfig.setEvictionRegionConfigs(regionConfigs);
        conf.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        conf.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(conf);
        this.wakeupIntervalMillis = this.cache.getConfiguration().getEvictionConfig().getWakeupInterval();
        System.out.println("-- wakeupInterval is " + this.wakeupIntervalMillis);
        if (this.wakeupIntervalMillis < 0L) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis));
        }
        this.t2_ex = null;
        this.t1_ex = null;
        this.isTrue = true;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testInUseEviction() throws Exception {
        Fqn f;
        Fqn fqn;
        String str;
        int i;
        String rootStr = "/org/jboss/test/data/inuse/";
        for (i = 0; i < 10; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        System.out.println("-- Marking as in-use");
        this.cache.getRegionManager().getRegion(Fqn.fromString((String)(rootStr + 5)), false).markNodeCurrentlyInUse(Fqn.fromString((String)(rootStr + 5)), 0L);
        for (i = 10; i < 15; ++i) {
            str = rootStr + i;
            fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        new EvictionController((Cache)this.cache).startEviction();
        for (i = 0; i < 5; ++i) {
            f = Fqn.fromString((String)(rootStr + i));
            assert (null == this.cache.getNode(f)) : f + " should be null";
        }
        AssertJUnit.assertNotNull((Object)this.cache.getNode(Fqn.fromString((String)(rootStr + 5))));
        for (i = 6; i < 11; ++i) {
            f = Fqn.fromString((String)(rootStr + i));
            assert (null == this.cache.getNode(f)) : f + " should be null";
        }
        for (i = 11; i < 15; ++i) {
            f = Fqn.fromString((String)(rootStr + i));
            assert (null != this.cache.getNode(f)) : f + " should not be null";
        }
    }

    public void testEviction() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            try {
                this.cache.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        System.out.println(this.cache.toString());
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500L);
        System.out.println(this.cache.toString());
        String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testNodeVisited() throws InterruptedException {
        String rootStr = "/org/jboss/test/data/";
        System.out.println("REGIONS: " + this.cache.getRegionManager().dumpRegions());
        final Fqn fqn7 = Fqn.fromString((String)(rootStr + "7"));
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
            this.cache.getNode(fqn7);
        }
        System.out.println("Cache: " + CachePrinter.printCacheDetails(this.cache));
        Thread retrieverThread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        LRUPolicyTest.this.cache.getNode(fqn7);
                        1.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        retrieverThread.setDaemon(true);
        retrieverThread.start();
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, Fqn.fromString((String)(rootStr + 3))));
        String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
        NodeSPI n = this.cache.getNode(fqn7);
        assert (n != null);
        val = (String)n.get((Object)(rootStr + "7"));
        AssertJUnit.assertNotNull((String)"Node should not be empty ", (Object)val);
        retrieverThread.interrupt();
        retrieverThread.join();
        new EvictionController((Cache)this.cache).startEviction(true);
        assert (this.waitForEviction((Cache)this.cache, 30L, TimeUnit.SECONDS, Fqn.fromString((String)(rootStr + 7))));
        val = (String)this.cache.get(rootStr + "7", (Object)(rootStr + "7"));
        System.out.println("-- val=" + val);
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testNodeRemoved() {
        String rootStr = "/org/jboss/test/data/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i + "/" + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        String str1 = rootStr + "7";
        Fqn fqn1 = Fqn.fromString((String)str1);
        String str2 = rootStr + "7/7";
        Fqn fqn2 = Fqn.fromString((String)str2);
        this.cache.get(fqn1, (Object)str1);
        this.cache.get(fqn2, (Object)str2);
        new EvictionController((Cache)this.cache).startEviction();
        this.cache.get(fqn1, (Object)str1);
        this.cache.get(fqn2, (Object)str2);
        new EvictionController((Cache)this.cache).startEviction();
        String val = (String)this.cache.get(rootStr + "7/7", (Object)(rootStr + "7/7"));
        AssertJUnit.assertNotNull((String)"Node should not be empty ", (Object)val);
        this.cache.removeNode(fqn1);
        TestingUtil.sleepThread(this.wakeupIntervalMillis + 500L);
        new EvictionController((Cache)this.cache).startEviction();
        val = (String)this.cache.get(rootStr + "7/7", (Object)(rootStr + "7/7"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testCompleteRemoval() throws Exception {
        String rootStr = "/test/";
        Fqn parent = Fqn.fromString((String)(rootStr + "parent"));
        this.cache.put(parent, (Object)"key", (Object)"value");
        this.cache.put(Fqn.fromRelativeElements((Fqn)parent, (Object[])new String[]{"child"}), (Object)"key", (Object)"value");
        long period = (this.wakeupIntervalMillis + this.testRegionTTLMillis) * 2L;
        System.out.println("-- Sleeping for " + period);
        TestingUtil.sleepThread(period);
        AssertJUnit.assertFalse((String)"Parent not completely removed", (boolean)this.cache.getRoot().hasChild(parent));
    }

    public void testConcurrentPutAndEvict() throws Exception {
        this.cache.stop();
        this.cache.destroy();
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.cache.create();
        this.cache.start();
        this.cache.put("/test/concurrentPutAndEvict", (Object)"value", (Object)1);
        for (int i = 0; i < 10; ++i) {
            new MyPutter("Putter" + i).start();
        }
        int counter = 0;
        do {
            ++counter;
            if (this.t1_ex != null) {
                AssertJUnit.fail((String)("Exception generated in put() " + this.t1_ex));
            }
            System.out.println("-- nodes/locks: " + this.cache.getNumberOfNodes() + "/" + this.cache.getNumberOfLocksHeld());
            TestingUtil.sleepThread(1000L);
        } while (counter <= 5);
        this.isTrue = false;
    }

    public void testForEvictionInternalError() {
        String rootStr = "/test/testdata";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        TestingUtil.sleepThread(2L * (this.wakeupIntervalMillis + this.testRegionTTLMillis));
        String val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache.put(fqn, (Object)str, (Object)str);
        }
        this.cache.removeNode(Fqn.ROOT);
        TestingUtil.sleepThread(2L * this.wakeupIntervalMillis + 1000L);
        val = (String)this.cache.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"Node should be empty ", (Object)val);
    }

    public void testOvereviction() throws Exception {
        Node node = this.cache.getRoot().addChild(Fqn.fromString((String)"/base/"));
        node.setResident(true);
        this.cache.getRoot().setResident(true);
        EvictionWatcher ew = new EvictionWatcher((Cache<?, ?>)this.cache, Fqn.fromString((String)"/base/1"));
        for (int i = 1; i < this.baseRegionMaxNodes + 2; ++i) {
            Fqn f = Fqn.fromString((String)("/base/" + i));
            this.cache.put(f, (Object)"key", (Object)("base" + i));
        }
        new EvictionController((Cache)this.cache).startEviction();
        assert (ew.waitForEviction(30L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((int)this.baseRegionMaxNodes, (int)this.cache.getRoot().getChild(Fqn.fromString((String)"/base")).getChildren().size());
    }

    class MyPutter
    extends Thread {
        public MyPutter(String name) {
            super(name);
        }

        public void run() {
            int i = 0;
            String myName = "/test/test1/node" + this.getName();
            while (LRUPolicyTest.this.isTrue) {
                try {
                    LRUPolicyTest.this.cache.put(myName + i++, (Object)"value", (Object)i);
                    MyPutter.sleep(1L);
                }
                catch (IllegalStateException ise) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (LRUPolicyTest.this.t1_ex != null) continue;
                    LRUPolicyTest.this.t1_ex = e;
                }
            }
        }
    }
}

