/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.RegionImpl;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionTestsBase;
import org.jboss.cache.eviction.MRUAlgorithm;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="eviction.MRUAlgorithmTest")
public class MRUAlgorithmTest
extends EvictionTestsBase {
    MRUAlgorithm algorithm;
    RegionManager regionManager;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.regionManager = new RegionManagerImpl();
        MRUAlgorithmConfig config = new MRUAlgorithmConfig();
        config.setMaxNodes(0);
        this.algorithm = (MRUAlgorithm)this.createAndAssignToRegion("/a/b", this.regionManager, (EvictionAlgorithmConfig)config);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.regionManager = null;
        this.algorithm = null;
    }

    public void testMaxNodes() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        MRUAlgorithmConfig config = (MRUAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(1);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        config.setMaxNodes(100);
        for (int i = 0; i < 150; ++i) {
            Fqn fqn = Fqn.fromString((String)("/a/b/c/" + Integer.toString(i)));
            region.registerEvictionEvent(fqn, EvictionEvent.Type.ADD_NODE_EVENT);
        }
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((int)100, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMRU() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/f");
        Fqn fqn5 = Fqn.fromString((String)"/a/b/g");
        Fqn fqn6 = Fqn.fromString((String)"/a/b/h");
        Fqn fqn7 = Fqn.fromString((String)"/a/b/i");
        Fqn fqn8 = Fqn.fromString((String)"/a/b/j");
        Fqn fqn9 = Fqn.fromString((String)"/a/b/k");
        Fqn fqn10 = Fqn.fromString((String)"/a/b/l");
        RegionImpl region = (RegionImpl)this.regionManager.getRegion("/a/b", true);
        MRUAlgorithmConfig config = (MRUAlgorithmConfig)region.getEvictionRegionConfig().getEvictionAlgorithmConfig();
        config.setMaxNodes(8);
        region.registerEvictionEvent(fqn1, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn3, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn5, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn6, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn7, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn8, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((int)8, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.registerEvictionEvent(fqn9, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn10, EvictionEvent.Type.ADD_NODE_EVENT);
        AssertJUnit.assertEquals((int)8, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.registerEvictionEvent(fqn2, EvictionEvent.Type.ADD_NODE_EVENT);
        region.registerEvictionEvent(fqn4, EvictionEvent.Type.ADD_NODE_EVENT);
        this.algorithm.process(region.getEvictionEventQueue());
        AssertJUnit.assertEquals((int)8, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        AssertJUnit.assertNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn2));
        AssertJUnit.assertNull((String)("No FQN4 " + this.algorithm.getEvictionQueue()), (Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn4));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn1));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn3));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn5));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn6));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn7));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn8));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn9));
        AssertJUnit.assertNotNull((Object)this.algorithm.getEvictionQueue().getNodeEntry(fqn10));
    }
}

